/*
 * Java
 *
 * Copyright 2011-2019 IS2T. All rights reserved
 * IS2T PROPRIETARY/CONFIDENTIAL Use is subject to license terms.
 */
package com.is2t.vm.support.err;

import ej.error.ErrorMessages;

/**
 * CLDC Error messages
 */
@SuppressWarnings("nls")
public class EDCErrorMessages implements ErrorMessages{

	// StackOverflow errors
	// WARNING: must be synchronized with VM class JavaStackAllocator
	/**
	 * Error code for {@link #newStackBlock()}. Stack space if full.
	 */
	public static final int SOE_ALLOCATION_OUT_OF_MEMORY 				= -1; //WARNING: this error code is referenced by VM class JavaStackAllocator

	/**
	 * Error code for {@link #newStackBlock()}. No block could be allocated with the given size.
	 */
	public static final int SOE_ALLOCATION_NO_BLOCK_FOR_GIVEN_SIZE	= -2; //WARNING: this error code is referenced by VM class JavaStackAllocator

	/**
	 * Error code for {@link #newStackBlock()}. Max stack size reached.
	 */
	public static final int SOE_ALLOCATION_MAX_STACK_SIZE_REACHED 	= -3; //WARNING: this error code is referenced by VM class JavaStackAllocator

	/**
	 * Error code for invoke native stackgroup. No stack found for the native
	 */
	public static final int SOE_ALLOCATION_NATIVE_STACK 	= -4; //WARNING: this error code is referenced by VM class JavaStackAllocator

	// Messages on I/O errors
	public static final int StreamClosed = 1 ;
    public static final int StreamMarkNotSupported = 2;
    public static final int StreamCantSyncOnNull = 3;
    public static final int StringIndexOutOfRange = 4;
    // Illegal argument
    public static final int ArgumentMustBePositive = 5;
    public static final int ArgumentInvalidRadix = 6;

    public static final int ReaderResetNotSupported = 7;

    // NumberFormatException
    public static final int EmptyString = 8;

	public static final int StringBuilderStartOutOfRange = 9;
    public static final int StringBuilderEndOutOfRange = 10;
	public static final int ThrowableCouldNotSuppressItself = 11;
	public static final int ThrowableCouldNotSuppressNull = 12;
	
	@Override
	public String category(){
		return "EDC-1.3";
	}

	// ALL NLS messages are held here
	@Override
	public String messageAt(int index){
		switch(index){
		case ReaderResetNotSupported : 	return "Operation not supported: reset()";
		case StreamClosed: 				return "The stream is closed";
        case StreamMarkNotSupported : 	return "Operation not supported: mark(int)";
        case StreamCantSyncOnNull: 		return "Can't synchronize on 'null'";
        case StringIndexOutOfRange: 	return "String index out of range";
        case ArgumentMustBePositive: 	return "n must be positive";
        case ArgumentInvalidRadix: 		return "Invalid radix. Must be 0 through 36";
        case EmptyString: 				return "Empty string";
        case StringBuilderStartOutOfRange: 				return "StringBuilder start index out of range";
        case StringBuilderEndOutOfRange: 				return "StringBuilder end index out of range";
        case ThrowableCouldNotSuppressItself:
			return "Throwable could not suppress itself.";
		case ThrowableCouldNotSuppressNull:
			return "Exception could not be suppressed if null.";
        case SOE_ALLOCATION_OUT_OF_MEMORY: 				return "The Java stack space if full";
        case SOE_ALLOCATION_NO_BLOCK_FOR_GIVEN_SIZE: 	return "No Java stack block could be allocated with the given size";
        case SOE_ALLOCATION_MAX_STACK_SIZE_REACHED: 	return "Maximum stack size for a thread has been reached";
        case SOE_ALLOCATION_NATIVE_STACK: 				return "No native stack found to execute the Java native method";
		default: 						return ("Unknown error ("+index)+')';
		}
	}
}
