/*
 * Java
 *
 * Copyright 2010-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */ 
package com.is2t.vm.support;

import java.util.TimeZone;

/**
 * {@link TimeZone} entry where id is composed of two parts such as <code>Europe/Paris</code>, ...
 * This allow reducing String literal footprint. Id is computed on the fly in RAM by {@link #getId()}.
 */
public class TimeZoneComposedEntry extends TimeZoneEntry {

	// super.id == idPart0
	protected String idPart1;
	
	public String getId(){
		return id+'/'+idPart1;
	}
}
