/*
 * Java
 *
 * Copyright 2008-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.vm.support;

import java.util.Date;
import java.util.TimeZone;

public class GMTTimeZone extends TimeZone {

	/* Singleton */
	private static GMTTimeZone instance = new GMTTimeZone() ;
	
	/**
	 * Default constructor.
	 */
	private GMTTimeZone() {
		this.id = "GMT" ; //$NON-NLS-1$
	}
	
	public static GMTTimeZone getInstance() {
		return GMTTimeZone.instance ;
	}
	
	/**
     * Gets offset, for current date, modified in case of daylight savings.
     * This is the offset to add *to* GMT to get local time. Gets the time zone
     * offset, for current date, modified in case of daylight to* GMT to get
     * local time. Assume that the start and end month are distinct. This
     * method may return incorrect results for rules that start at the end of
     * February (e.g., last Sunday in February) or the beginning of March
     * (e.g., March 1).
     */
	public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
		return 0 ;
	}
	
	/**
     * Gets the GMT offset for this time zone.
     */
	public int getRawOffset() {
		return 0;
	}
	
	/**
     * Queries if this time zone uses Daylight Savings Time.
     */
	public boolean useDaylightTime() {
		return false ;
	}

	public String getID() {
		return id;
	}

	// TODO WI 8375
	public boolean inDaylightTime(Date date) {
		throw new RuntimeException();
	}

	// TODO WI 8375
	public void setRawOffset(int offsetMillis) {
		throw new RuntimeException();
	}
}
