/*
 * Java
 *
 * Copyright 2004-2020 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */ 
package com.is2t.vm.support;

/**
 * Compiletime constants for EDC-1.x implementation calibration
 */
public interface CalibrationConstants {
	
	/**
	 * {@link InputStreamReader} size of bytes buffer cache.
	 * Constraint: must be greater than or equal to the maximum {@link EncodingConversion#getMaxBytesPerChar()}
	 */
	int READER_WRITER_BUFFER_SIZE = 4096;
	
	/**
	 * Turn on/off fast prinln with a single {@link OutputStreamWriter} call
	 */
	boolean ENABLE_FAST_PRINTLN = true;

	/**
	 * Turn on/off optional platform specific resource loader
	 */
	boolean ENABLE_RESOURCE_LOADER = true;
	
	/**
	 * BON constant to enable SecurityManager checks at runtime 
	 */
	String CONSTANT_USE_SECURITYMANAGER = "com.microej.library.edc.securitymanager.enabled" ; //$NON-NLS-1$
	
	/**
	 * BON constant to enable support of Unicode supplementary characters
	 */
	String CONSTANT_SUPPLEMENTARY_CHARACTER = "com.microej.library.edc.supplementarycharacter.enabled" ; //$NON-NLS-1$
}
