/*
 * Java
 *
 * Copyright 2011-2014 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.tools;

public class GeometryTools {
	
	private GeometryTools() {
	}

	//(1) check if the absolute value of scanlength is less than width
	//(2) check if the scan of the array do not exceed the bounds
	public static void checkScanBounds(int arrayLength, int offset, int scanlength, int width, int height) {
		//(2) max (or min depending on scanlength) bound reach by the array scan
		int endBound = (height-1)*scanlength;

		//(1) must compare with the negative absolute value of scanlength in order to manage scanlength = Integer.MIN_VALUE
		// because -Integer.MIN_VALUE == Integer.MIN_VALUE
		int scanlengthNeg;
		int widthNeg = -width;

		if(scanlength > 0) {
			scanlengthNeg = -scanlength;
			endBound += width;
		} else {
			scanlengthNeg = scanlength;
		}

		//(1)
		if(widthNeg < scanlengthNeg) {
			throw new IllegalArgumentException();
		}

		//(2)
		ArrayTools.checkArrayBounds(arrayLength, offset, endBound);
	}

	//check that the coordinates of a point are inside a rectangle or not
	public static boolean contains(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
		return pointX >= rectX && pointX <= rectX + rectWidth
		&& pointY >= rectY && pointY <= rectY + rectHeight;
	}

}
