/*
 * Java
 *
 * Copyright 2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */ 
package com.is2t.reflect;

import ej.annotation.Nullable;

/**
 * Stack frame reification. 
 * The user can navigate through linked list using {@link #getPrevious()} and {@link #getNext()}
 * For non static methods, the receiver can be retrieved using {@link #getThis()}.
 * Some fields are "AUTOCOPIED" to sub calls: {@link #muidEvent}
 */
public class StackFrame {

	// | BOS | ... | previous | this | next | ... | TOS
	@Nullable
	private StackFrame next;	// VM known
	@Nullable
	private StackFrame previous;// VM known 
	
	/**
	 * MicroUI debug event slot. This field is automatically copied 
	 * to next stack frames on method invocation
	 */
	// S3-AUTO-COPY	(See this tag is S3 implementation (Interpretor.invokeMethod()))
	@Nullable
	public Object muidEvent; // VM known	
	
	/**
	 * @return the receiver, null on static method
	 */
	public native Object getThis();
	
	/**
	 * | BOS | ... | previous | this | next | ... | TOS
	 * @return the upper call stack, null if stack is the top of stack (TOS)
	 */
	@Nullable
	public StackFrame getNext(){
		return next;
	}
	
	/**
	 * | BOS | ... | previous | this | next | ... | TOS
	 * @return the lower call stack, null if stack is the bottom of stack (BOS)
	 */
	@Nullable
	public StackFrame getPrevious(){
		return previous;
	}
}
