/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.display;

import ej.microui.Log;
import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIFont;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImage;
import ej.microui.display.MicroUIRenderableString;
import ej.microui.display.Rectangle;

public class LLUIPainter {
    public static final int DRAWING_SUCCESS = 0;
    public static final int DRAWING_LOG_ERROR = Integer.MIN_VALUE;
    public static final int DRAWING_LOG_NOT_IMPLEMENTED = 1;
    public static final int DRAWING_LOG_FORBIDDEN = 2;
    public static final int DRAWING_LOG_OUT_OF_MEMORY = 4;
    public static final int DRAWING_LOG_CLIP_MODIFIED = 8;
    public static final int DRAWING_LOG_MISSING_CHARACTER = 16;
    public static final int DRAWING_LOG_LIBRARY_INCIDENT = 0x20000000;
    public static final int DRAWING_LOG_UNKNOWN_INCIDENT = 0x40000000;

    private LLUIPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePixel(byte[] byArray, int n2, int n3) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(80, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3);
                if (microUIGraphicsContext.isPointInClip(n2, n3)) {
                    microUIGraphicsContext.configureClip(false);
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).writePixel(microUIGraphicsContext, n2, n3);
                } else {
                    LLUIPainter.logOutOfClip(microUIGraphicsContext);
                }
                Log.recordEventEnd(80, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLine(byte[] byArray, int n2, int n3, int n4, int n5) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(81, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, n5);
                LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawLine(microUIGraphicsContext, n2, n3, n4, n5);
                Log.recordEventEnd(81, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHorizontalLine(byte[] byArray, int n2, int n3, int n4) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(82, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4);
                if (n4 > 0) {
                    Rectangle rectangle = LLUIPainter.a(microUIGraphicsContext, n2, n3, n2 + n4 - 1, n3);
                    if (rectangle != null) {
                        microUIGraphicsContext.configureClip(false);
                        LLUIPainter.logDrawnRegion(microUIGraphicsContext, rectangle);
                        LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawHorizontalLine(microUIGraphicsContext, rectangle.getX1(), rectangle.getX2(), rectangle.getY1());
                    } else {
                        LLUIPainter.logOutOfClip(microUIGraphicsContext);
                    }
                }
                Log.recordEventEnd(82, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawVerticalLine(byte[] byArray, int n2, int n3, int n4) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(83, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4);
                Rectangle rectangle = LLUIPainter.a(microUIGraphicsContext, n2, n3, n2, n3 + n4 - 1);
                if (rectangle != null) {
                    microUIGraphicsContext.configureClip(false);
                    LLUIPainter.logDrawnRegion(microUIGraphicsContext, rectangle);
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawVerticalLine(microUIGraphicsContext, rectangle.getX1(), rectangle.getY1(), rectangle.getY2());
                } else {
                    LLUIPainter.logOutOfClip(microUIGraphicsContext);
                }
                Log.recordEventEnd(83, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectangle(byte[] byArray, int n2, int n3, int n4, int n5) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(84, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, n5);
                if (n4 > 0 && n5 > 0) {
                    int n6 = n2;
                    int n7 = n3;
                    int n8 = n2 + n4 - 1;
                    int n9 = n3 + n5 - 1;
                    microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRectangleInClip(n6, n7, n8, n9));
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawRectangle(microUIGraphicsContext, n6, n7, n8, n9);
                }
                Log.recordEventEnd(84, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRectangle(byte[] byArray, int n2, int n3, int n4, int n5) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(85, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, n5);
                if (n4 > 0 && n5 > 0) {
                    Rectangle rectangle = LLUIPainter.a(microUIGraphicsContext, n2, n3, n2 + n4 - 1, n3 + n5 - 1);
                    if (rectangle != null) {
                        microUIGraphicsContext.configureClip(false);
                        LLUIPainter.logDrawnRegion(microUIGraphicsContext, rectangle);
                        LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).fillRectangle(microUIGraphicsContext, rectangle.getX1(), rectangle.getY1(), rectangle.getX2(), rectangle.getY2());
                    } else {
                        LLUIPainter.logOutOfClip(microUIGraphicsContext);
                    }
                }
                Log.recordEventEnd(85, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRoundedRectangle(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(86, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, n5, n6, n7);
                if (n4 > 0 && n5 > 0) {
                    microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRegionInClip(n2, n3, n4, n5));
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawRoundedRectangle(microUIGraphicsContext, n2, n3, n4, n5, n6, n7);
                }
                Log.recordEventEnd(86, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRoundedRectangle(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(87, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, n5, n6, n7);
                if (n4 > 0 && n5 > 0) {
                    Rectangle rectangle = LLUIPainter.a(microUIGraphicsContext, n2, n3, n2 + n4 - 1, n3 + n5 - 1);
                    if (rectangle != null) {
                        microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRegionInClip(n2, n3, n4, n5));
                        LLUIPainter.logDrawnRegion(microUIGraphicsContext, rectangle);
                        LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).fillRoundedRectangle(microUIGraphicsContext, n2, n3, n4, n5, n6, n7);
                    } else {
                        LLUIPainter.logOutOfClip(microUIGraphicsContext);
                    }
                }
                Log.recordEventEnd(87, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCircleArc(byte[] byArray, int n2, int n3, int n4, float f2, float f3) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(88, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, (int)f2, (int)f3);
                if (n4 > 0 && f3 != 0.0f) {
                    microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRegionInClip(n2, n3, n4, n4));
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawCircleArc(microUIGraphicsContext, n2, n3, n4, f2, f3);
                }
                Log.recordEventEnd(88, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEllipseArc(byte[] byArray, int n2, int n3, int n4, int n5, float f2, float f3) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(90, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, n5, (int)f2, (int)f3);
                if (n4 > 0 && n5 > 0 && f3 != 0.0f) {
                    microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRegionInClip(n2, n3, n4, n5));
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawEllipseArc(microUIGraphicsContext, n2, n3, n4, n5, f2, f3);
                }
                Log.recordEventEnd(90, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillCircleArc(byte[] byArray, int n2, int n3, int n4, float f2, float f3) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(89, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, (int)f2, (int)f3);
                if (n4 > 0 && f3 != 0.0f) {
                    microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRegionInClip(n2, n3, n4, n4));
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).fillCircleArc(microUIGraphicsContext, n2, n3, n4, f2, f3);
                }
                Log.recordEventEnd(89, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillEllipseArc(byte[] byArray, int n2, int n3, int n4, int n5, float f2, float f3) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(91, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, n5, (int)f2, (int)f3);
                if (n4 > 0 && n5 > 0 && f3 != 0.0f) {
                    microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRegionInClip(n2, n3, n4, n5));
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).fillEllipseArc(microUIGraphicsContext, n2, n3, n4, n5, f2, f3);
                }
                Log.recordEventEnd(91, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEllipse(byte[] byArray, int n2, int n3, int n4, int n5) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(92, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, n5);
                if (n4 > 0 && n5 > 0) {
                    microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRegionInClip(n2, n3, n4, n5));
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawEllipse(microUIGraphicsContext, n2, n3, n4, n5);
                }
                Log.recordEventEnd(92, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillEllipse(byte[] byArray, int n2, int n3, int n4, int n5) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(93, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4, n5);
                if (n4 > 0 && n5 > 0) {
                    microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRegionInClip(n2, n3, n4, n5));
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).fillEllipse(microUIGraphicsContext, n2, n3, n4, n5);
                }
                Log.recordEventEnd(93, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCircle(byte[] byArray, int n2, int n3, int n4) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(94, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4);
                if (n4 > 0) {
                    microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRegionInClip(n2, n3, n4, n4));
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawCircle(microUIGraphicsContext, n2, n3, n4);
                }
                Log.recordEventEnd(94, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillCircle(byte[] byArray, int n2, int n3, int n4) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(95, Log.mapGraphicsContext(microUIGraphicsContext), n2, n3, n4);
                if (n4 > 0) {
                    microUIGraphicsContext.configureClip(!microUIGraphicsContext.isRegionInClip(n2, n3, n4, n4));
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).fillCircle(microUIGraphicsContext, n2, n3, n4);
                }
                Log.recordEventEnd(95, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            if (microUIGraphicsContext.requestDrawing()) {
                MicroUIImage microUIImage = lLUIDisplay.mapMicroUIImage(byArray2);
                Log.recordEvent(96, Log.mapGraphicsContext(microUIGraphicsContext), Log.mapImage(microUIImage), n2, n3, n4, n5, n6, n7, n8);
                if (!microUIImage.isClosed() && n8 > 0) {
                    Rectangle rectangle = new Rectangle(n2, n3, n2 + n4 - 1, n3 + n5 - 1);
                    microUIImage = lLUIDisplay.getSource(microUIImage);
                    Rectangle rectangle2 = LLUIPainter.a(microUIImage, rectangle, n6, n7);
                    rectangle = LLUIPainter.a(microUIGraphicsContext, rectangle2, rectangle.getX1(), rectangle.getY1());
                    Rectangle rectangle3 = LLUIPainter.a(microUIGraphicsContext, rectangle2);
                    if (rectangle3 != null) {
                        microUIGraphicsContext.configureClip(false);
                        LLUIPainter.logDrawnRegion(microUIGraphicsContext, rectangle3);
                        LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawImage(microUIGraphicsContext, microUIImage, rectangle.getX1() + (rectangle3.getX1() - rectangle2.getX1()), rectangle.getY1() + (rectangle3.getY1() - rectangle2.getY1()), rectangle3.getWidth(), rectangle3.getHeight(), rectangle3.getX1(), rectangle3.getY1(), n8);
                    } else {
                        LLUIPainter.logOutOfClip(microUIGraphicsContext);
                    }
                }
                Log.recordEventEnd(96, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawString(byte[] byArray, char[] cArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            MicroUIFont microUIFont = lLUIDisplay.mapMicroUIFont(byArray2);
            char[] cArray2 = lLUIDisplay.mapString(cArray, n2, n3);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(97, Log.mapGraphicsContext(microUIGraphicsContext), n3, n4, n5);
                if (n3 > 0) {
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawString(microUIGraphicsContext, cArray2, microUIFont, n4, n5);
                }
                Log.recordEventEnd(97, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stringWidth(char[] cArray, int n2, int n3, byte[] byArray) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            Log.recordEvent(62, n3);
            if (n3 > 0) {
                MicroUIFont microUIFont = lLUIDisplay.mapMicroUIFont(byArray);
                char[] cArray2 = lLUIDisplay.mapString(cArray, n2, n3);
                return LLUIDisplay.Instance.getUIFontDrawer(microUIFont).stringWidth(cArray2, microUIFont);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRenderableString(byte[] byArray, char[] cArray, int n2, int n3, byte[] byArray2, int n4, byte[] byArray3, int n5, int n6) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIGraphicsContext microUIGraphicsContext = lLUIDisplay.mapMicroUIGraphicsContext(byArray);
            MicroUIFont microUIFont = lLUIDisplay.mapMicroUIFont(byArray2);
            char[] cArray2 = lLUIDisplay.mapString(cArray, n2, n3);
            MicroUIRenderableString microUIRenderableString = lLUIDisplay.mapMicroUIRenderableString(byArray3);
            if (microUIGraphicsContext.requestDrawing()) {
                Log.recordEvent(97, Log.mapGraphicsContext(microUIGraphicsContext), n3, n5, n6);
                if (n3 > 0) {
                    LLUIDisplay.Instance.getUIDrawer(microUIGraphicsContext).drawRenderableString(microUIGraphicsContext, cArray2, microUIFont, n4, microUIRenderableString, n5, n6);
                }
                Log.recordEventEnd(97, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int initializeRenderableStringSNIContext(char[] cArray, int n2, int n3, byte[] byArray, byte[] byArray2) {
        LLUIDisplay lLUIDisplay;
        LLUIDisplay lLUIDisplay2 = lLUIDisplay = LLUIDisplay.Instance;
        synchronized (lLUIDisplay2) {
            MicroUIFont microUIFont = lLUIDisplay.mapMicroUIFont(byArray);
            char[] cArray2 = lLUIDisplay.mapString(cArray, n2, n3);
            MicroUIRenderableString microUIRenderableString = lLUIDisplay.mapMicroUIRenderableString(byArray2);
            return LLUIDisplay.Instance.getUIFontDrawer(microUIFont).initializeRenderableStringSNIContext(cArray2, microUIFont, microUIRenderableString);
        }
    }

    private static Rectangle a(MicroUIGraphicsContext microUIGraphicsContext, Rectangle rectangle) {
        return LLUIPainter.a(microUIGraphicsContext, rectangle.getX1(), rectangle.getY1(), rectangle.getX2(), rectangle.getY2());
    }

    private static Rectangle a(MicroUIGraphicsContext microUIGraphicsContext, int n2, int n3, int n4, int n5) {
        n2 = Math.max(n2, microUIGraphicsContext.getClipX1());
        n3 = Math.max(n3, microUIGraphicsContext.getClipY1());
        n4 = Math.min(n4, microUIGraphicsContext.getClipX2());
        n5 = Math.min(n5, microUIGraphicsContext.getClipY2());
        return n4 >= n2 && n5 >= n3 ? new Rectangle(n2, n3, n4, n5) : null;
    }

    private static Rectangle a(MicroUIImage microUIImage, Rectangle rectangle, int n2, int n3) {
        int n4 = rectangle.getX1();
        int n5 = rectangle.getY1();
        int n6 = rectangle.getWidth();
        int n7 = rectangle.getHeight();
        if (n4 < 0) {
            n6 += n4;
            n2 -= n4;
            n4 = 0;
        }
        if (n4 + n6 > microUIImage.getWidth()) {
            n6 = microUIImage.getWidth() - n4;
        }
        if (n5 < 0) {
            n7 += n5;
            n3 -= n5;
            n5 = 0;
        }
        if (n5 + n7 > microUIImage.getHeight()) {
            n7 = microUIImage.getHeight() - n5;
        }
        rectangle.setX1(n4);
        rectangle.setY1(n5);
        rectangle.setX2(n4 + n6 - 1);
        rectangle.setY2(n5 + n7 - 1);
        return new Rectangle(n2, n3, n2 + n6 - 1, n3 + n7 - 1);
    }

    public static void logDrawnRegion(MicroUIGraphicsContext microUIGraphicsContext, Rectangle rectangle) {
        LLUIPainter.logDrawnRegion(microUIGraphicsContext, rectangle.getX1(), rectangle.getY1(), rectangle.getWidth(), rectangle.getHeight());
    }

    public static void logDrawnRegion(MicroUIGraphicsContext microUIGraphicsContext, int n2, int n3, int n4, int n5) {
        Log.recordEvent(68, Log.mapGraphicsContext(microUIGraphicsContext), Log.mapBoolean(!microUIGraphicsContext.isClipEnabled()), n2, n3, n4, n5);
    }

    public static void logOutOfClip(MicroUIGraphicsContext microUIGraphicsContext) {
        Log.recordEvent(67, Log.mapGraphicsContext(microUIGraphicsContext));
    }
}

