/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.display;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.microui.display.LLUIDisplay;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;

public interface LLUIDisplayImpl {
    public static final int BACKLIGHT_MIN = 0;
    public static final int BACKLIGHT_MAX = 100;
    public static final int CONTRAST_MIN = 0;
    public static final int CONTRAST_MAX = 100;

    public Image initialize();

    public void flush();

    public void newDrawingRegion(int var1, int var2, int var3, int var4, boolean var5);

    default public void waitFlush() {
    }

    default public Image getCurrentBackBuffer() {
        return this.getCurrentDrawingBuffer();
    }

    default public Image getCurrentDrawingBuffer() {
        throw new RuntimeException("LLUIDisplayImpl.getCurrentBackBuffer() must be implemented");
    }

    public Image getDisplayedImage();

    default public void setContrast(int n2) {
    }

    default public int getContrast() {
        return 0;
    }

    default public boolean hasBacklight() {
        return false;
    }

    default public void setBacklight(int n2) {
    }

    default public int getBacklight() {
        return 0;
    }

    default public boolean isColor() {
        return LLUIDisplay.Instance.getDisplayPixelDepth() > 4;
    }

    default public int getNumberOfColors() {
        return 1 << LLUIDisplay.Instance.getDisplayPixelDepth();
    }

    default public boolean isDoubleBuffered() {
        return true;
    }

    default public int convertARGBColorToDisplayColor(int n2) {
        return n2;
    }

    default public int convertDisplayColorToARGBColor(int n2) {
        return n2;
    }

    default public boolean prepareBlendingOfIndexedColors(AtomicInteger atomicInteger, AtomicInteger atomicInteger2) {
        return false;
    }

    default public Image decode(byte[] byArray) {
        return FrontPanel.getFrontPanel().newImage((InputStream)new ByteArrayInputStream(byArray));
    }
}

