/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.util.version.semver;

import com.is2t.util.version.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemVer
implements Version {
    private static final String DOT_PATTERN = "\\.";
    private static final String MAJOR = "major";
    private static final String MINOR = "minor";
    private static final String PATCH = "patch";
    private static final String PRE_RELEASE = "preRelease";
    private static final String BUILD_META_DATA = "buildMetaData";
    private static final String COMPONENT = "(?<%s>\\d+)";
    private static final String MAJOR_COMPONENT = String.format("(?<%s>\\d+)", "major");
    private static final String MINOR_COMPONENT = String.format("(?<%s>\\d+)", "minor");
    private static final String PATCH_COMPONENT = String.format("(?<%s>\\d+)", "patch");
    private static final String SIMPLE_VERSION = "(?:" + MAJOR_COMPONENT + "\\." + MINOR_COMPONENT + "\\." + PATCH_COMPONENT + ')';
    private static final String META = "[\\w-\\.]+";
    private static final String META_GROUP = "(?:\\%s(?<%s>[\\w-\\.]+))?";
    private static final String PRE_RELEASE_PREFIX = "-";
    private static final String BUILD_META_DATA_PREFIX = "+";
    private static final String PRE_RELEASE_COMPONENT = String.format("(?:\\%s(?<%s>[\\w-\\.]+))?", "-", "preRelease");
    private static final String BUILD_META_DATA_COMPONENT = String.format("(?:\\%s(?<%s>[\\w-\\.]+))?", "+", "buildMetaData");
    private static final Pattern INFOS_PATTERN = Pattern.compile("^[\\w-\\.]+$");
    private static final Pattern SEM_VER_PATTERN = Pattern.compile('^' + SIMPLE_VERSION + PRE_RELEASE_COMPONENT + BUILD_META_DATA_COMPONENT + '$');
    private final int major;
    private final int minor;
    private final int patch;
    private final MetaInfos preRelease;
    private final MetaInfos buildMetaData;

    private SemVer(String version) throws IllegalArgumentException, NullPointerException {
        String workingVersion = version.trim();
        Matcher matcher = SEM_VER_PATTERN.matcher(workingVersion);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(version);
        }
        this.major = Integer.parseInt(matcher.group(MAJOR));
        this.minor = Integer.parseInt(matcher.group(MINOR));
        this.patch = Integer.parseInt(matcher.group(PATCH));
        this.preRelease = this.computeMetaInfos(matcher.group(PRE_RELEASE));
        this.buildMetaData = this.computeMetaInfos(matcher.group(BUILD_META_DATA));
        assert (this.toString().equals(version));
    }

    public SemVer(int major, int minor, int patch, String preRelease, String buildMetaData) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = this.computeMetaInfos(preRelease);
        this.buildMetaData = this.computeMetaInfos(buildMetaData);
    }

    public SemVer(int major, int minor, int patch, String preRelease) {
        this(major, minor, patch, preRelease, null);
    }

    public SemVer(int major, int minor, int patch) {
        this(major, minor, patch, null, null);
    }

    public static SemVer valueOf(String version) throws IllegalArgumentException, NullPointerException {
        return new SemVer(version);
    }

    public int hashCode() {
        int hashCode = (this.major << 24) + (this.minor << 16) + (this.patch << 8);
        if (this.preRelease != null) {
            hashCode -= this.preRelease.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        try {
            return this.compareTo((SemVer)obj) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        StringBuffer meta = new StringBuffer();
        if (this.preRelease != null) {
            meta.append(PRE_RELEASE_PREFIX).append(this.preRelease);
        }
        if (this.buildMetaData != null) {
            meta.append(BUILD_META_DATA_PREFIX).append(this.buildMetaData);
        }
        return String.format("%d.%d.%d%s", this.major, this.minor, this.patch, meta.toString());
    }

    @Override
    public int compareTo(Version v) {
        if (v instanceof SemVer) {
            SemVer s = (SemVer)v;
            int majorDiff = this.major - s.major;
            if (majorDiff != 0) {
                return majorDiff;
            }
            int minorDiff = this.minor - s.minor;
            if (minorDiff != 0) {
                return minorDiff;
            }
            int patchDiff = this.patch - s.patch;
            if (patchDiff != 0) {
                return patchDiff;
            }
            if (this.preRelease != null) {
                if (s.preRelease == null) {
                    return -1;
                }
                return this.preRelease.compareTo(s.preRelease);
            }
            if (s.preRelease == null) {
                return 0;
            }
            return 1;
        }
        throw new IllegalArgumentException("Cannot compare " + SemVer.class.getName() + " with " + v.getClass().getName());
    }

    @Override
    public boolean isCompatible(Version other) {
        if (other instanceof SemVer) {
            return this.isCompatible((SemVer)other);
        }
        return false;
    }

    @Override
    public boolean isEquivalent(Version other) {
        if (other instanceof SemVer) {
            return this.isEquivalent((SemVer)other);
        }
        return false;
    }

    public boolean isCompatible(SemVer other) {
        if (this.major == 0) {
            return this.equals(other);
        }
        return this.major == other.major && this.compareTo(other) >= 0;
    }

    public boolean isEquivalent(SemVer other) {
        if (this.major == 0) {
            return this.equals(other);
        }
        return this.major == other.major && this.minor == other.minor && this.compareTo(other) >= 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public MetaInfos getPreRelease() {
        return this.preRelease;
    }

    public MetaInfos getBuildMetaData() {
        return this.buildMetaData;
    }

    private MetaInfos computeMetaInfos(String metaInfos) {
        try {
            return new MetaInfos(metaInfos);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public class MetaInfos
    implements Comparable<MetaInfos> {
        private static final String DOT = ".";
        private final String raw;
        private final FieldInfo[] fields;

        private MetaInfos(String metaInfos) {
            if (metaInfos.isEmpty()) {
                throw new IllegalArgumentException();
            }
            Matcher matcher = INFOS_PATTERN.matcher(metaInfos);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(metaInfos);
            }
            if (metaInfos.startsWith(DOT) || metaInfos.endsWith(DOT)) {
                throw new IllegalArgumentException();
            }
            if (metaInfos.contains("..")) {
                throw new IllegalArgumentException();
            }
            String[] rawFields = metaInfos.split(SemVer.DOT_PATTERN);
            this.fields = new FieldInfo[rawFields.length];
            int i = rawFields.length;
            while (--i >= 0) {
                FieldInfo field;
                String rawField = rawFields[i];
                try {
                    Integer value = Integer.valueOf(rawField);
                    field = new FieldInfo(value);
                }
                catch (NumberFormatException e) {
                    field = new FieldInfo(rawField);
                }
                this.fields[i] = field;
            }
            assert (this.fields.length != 0);
            this.raw = metaInfos;
        }

        public int hashCode() {
            int hashCode = 0;
            System.out.println("SemVer.MetaInfos.hashCode() " + System.identityHashCode(SemVer.this));
            int i = this.fields.length;
            while (--i >= 0) {
                int fieldHashCode = this.fields[i].hashCode();
                hashCode = i % 2 == 0 ? hashCode + fieldHashCode : hashCode - fieldHashCode;
                System.out.println(i + " " + this.fields[i] + " " + fieldHashCode + " " + hashCode + " " + "RC0".hashCode());
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            try {
                return this.compareTo((MetaInfos)obj) == 0;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public int compareTo(MetaInfos o) {
            int i = -1;
            int length = Math.min(this.fields.length, o.fields.length);
            while (++i < length) {
                int diff = this.fields[i].compareTo(o.fields[i]);
                if (diff == 0) continue;
                return diff;
            }
            return this.fields.length - o.fields.length;
        }

        public String getRawMetaInfo() {
            return this.raw;
        }

        public int getFieldCount() {
            return this.fields.length;
        }

        public String getField(int fieldId) {
            try {
                return this.fields[fieldId].toString();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid id: " + fieldId, e);
            }
        }

        public String toString() {
            return this.raw;
        }

        class FieldInfo
        implements Comparable<FieldInfo> {
            final Object value;

            FieldInfo(Integer value) {
                this.value = value;
            }

            FieldInfo(String value) {
                this.value = value;
            }

            @Override
            public int compareTo(FieldInfo other) {
                boolean thisIsNumber = this.value instanceof Integer;
                boolean otherIsNumber = other.value instanceof Integer;
                boolean thisIsString = this.value instanceof String;
                boolean otherIsString = other.value instanceof String;
                if (thisIsNumber && otherIsNumber) {
                    return ((Integer)this.value).compareTo((Integer)other.value);
                }
                if (thisIsString && otherIsString) {
                    return ((String)this.value).compareTo((String)other.value);
                }
                if (thisIsNumber && otherIsString) {
                    return -1;
                }
                return 1;
            }

            public boolean equals(Object obj) {
                if (obj instanceof FieldInfo) {
                    return this.value.equals(((FieldInfo)obj).value);
                }
                return false;
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public String toString() {
                return this.value.toString();
            }
        }
    }
}

