/*
 * Decompiled with CFR 0.152.
 */
package ej.lang;

import ej.lang.WatchdogNativeSupport;

public abstract class Watchdog<T>
implements AutoCloseable {
    private static Thread WATCHDOG_CONTEXT_HANDLER;
    private static int WATCHDOG_JAVA_IDENTIFIER;
    private int nativeIdentifier = -1;
    private final int javaIdentifier = Watchdog.generateJavaIdentifier();
    private T context;

    public static boolean isSupportEnabled() {
        return WatchdogNativeSupport.supportEnabled();
    }

    private static synchronized int generateJavaIdentifier() {
        return WATCHDOG_JAVA_IDENTIFIER++;
    }

    public Watchdog() {
    }

    public Watchdog(long delay, T context) {
        this.start(delay, context);
    }

    public final T getContext() {
        return this.context;
    }

    public synchronized boolean isStarted() {
        return this.nativeIdentifier != -1;
    }

    public final synchronized void start(long delay, T context) {
        if (this.nativeIdentifier != -1) {
            this.close();
        }
        this.context = context;
        this.nativeIdentifier = WatchdogNativeSupport.claimAndStartWatchdog(this.javaIdentifier, delay, this);
        if (this.nativeIdentifier == -1 && WatchdogNativeSupport.supportEnabled()) {
            throw new InternalError();
        }
    }

    public abstract void trigger();

    public final synchronized void cancel() {
        WatchdogNativeSupport.cancelWatchdog(this.nativeIdentifier, this.javaIdentifier);
        this.context = null;
    }

    @Override
    public final synchronized void close() {
        WatchdogNativeSupport.cancelWatchdog(this.nativeIdentifier, this.javaIdentifier);
        this.context = null;
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!Watchdog.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        Watchdog otherWatchdog = (Watchdog)other;
        return this.javaIdentifier == otherWatchdog.javaIdentifier && this.nativeIdentifier == otherWatchdog.nativeIdentifier;
    }

    public final int hashCode() {
        return this.javaIdentifier;
    }

    static {
        WATCHDOG_JAVA_IDENTIFIER = 0;
        if (Watchdog.isSupportEnabled()) {
            WATCHDOG_CONTEXT_HANDLER = new Thread(new Runnable(){

                @Override
                public void run() {
                    WatchdogNativeSupport.registerContextHandlerThreads();
                    while (true) {
                        Object nextContext;
                        if ((nextContext = WatchdogNativeSupport.getNextContext()) != null) {
                            ((Watchdog)nextContext).trigger();
                            continue;
                        }
                        WatchdogNativeSupport.pauseContextHandlerThread();
                    }
                }
            });
            WATCHDOG_CONTEXT_HANDLER.start();
        }
    }
}

