/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wearable.frontpanel;

import com.microej.wearable.frontpanel.EventPointerHelper;
import ej.fp.MouseListener;
import ej.fp.widget.Pointer;
import java.util.Timer;
import java.util.TimerTask;

public class PointerListener
extends Pointer.PointerListenerToPointerEvents {
    private static final long LONG_PRESS_DELAY = 500L;
    private final Timer timer = new Timer();
    private TimerTask longPressTask;

    public void press(Pointer widget, int x, int y, MouseListener.MouseButton button) {
        super.press(widget, x, y, button);
        this.cancelLongPressTask();
        this.scheduleLongPressTask(this.getMicroUIGeneratorTag(widget));
    }

    public void move(Pointer widget, int x, int y) {
        super.move(widget, x, y);
        this.cancelLongPressTask();
    }

    public void release(Pointer widget, MouseListener.MouseButton button) {
        super.release(widget, button);
        this.cancelLongPressTask();
    }

    private void scheduleLongPressTask(final String eventGenerator) {
        TimerTask task;
        this.longPressTask = task = new TimerTask(){

            @Override
            public void run() {
                EventPointerHelper.sendLongEvent(eventGenerator, 0);
            }
        };
        this.timer.schedule(task, 500L);
    }

    private void cancelLongPressTask() {
        TimerTask longPressTask = this.longPressTask;
        if (longPressTask != null) {
            longPressTask.cancel();
            this.longPressTask = null;
        }
    }
}

