/*
 * Decompiled with CFR 0.152.
 */
package com.microej.painter;

import com.microej.painter.TransformedImagePainterNatives;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;
import ej.microvg.BlendMode;
import ej.microvg.Matrix;

public class TransformedImagePainter {
    private TransformedImagePainter() {
    }

    public static void drawImage(GraphicsContext gc, Image image, Matrix matrix, boolean bilinear) {
        TransformedImagePainter.drawImage(gc, image, 0, 0, image.getWidth(), image.getHeight(), matrix, bilinear, 255, BlendMode.SRC_OVER);
    }

    public static void drawImage(GraphicsContext gc, Image image, Matrix matrix, boolean bilinear, int alpha, BlendMode blendMode) {
        TransformedImagePainter.checkAlpha(alpha);
        TransformedImagePainter.drawImage(gc, image, 0, 0, image.getWidth(), image.getHeight(), matrix, bilinear, alpha, blendMode);
    }

    public static void drawImageRegion(GraphicsContext gc, Image image, int regionX, int regionY, int regionWidth, int regionHeight, Matrix matrix, boolean bilinear, int alpha, BlendMode blendMode) {
        TransformedImagePainter.checkAlpha(alpha);
        TransformedImagePainter.drawImage(gc, image, regionX, regionY, regionWidth, regionHeight, matrix, bilinear, alpha, blendMode);
    }

    private static void drawImage(GraphicsContext gc, Image image, int regionX, int regionY, int regionWidth, int regionHeight, Matrix matrix, boolean bilinear, int alpha, BlendMode blendMode) {
        TransformedImagePainterNatives.drawImage(gc.getSNIContext(), image.getSNIContext(), regionX, regionY, regionWidth, regionHeight, gc.getTranslationX(), gc.getTranslationY(), matrix.getSNIContext(), bilinear, alpha, blendMode.ordinal());
    }

    private static void checkAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException();
        }
    }
}

