/*
 * Decompiled with CFR 0.152.
 */
package ej.fp;

import ej.fp.Composite;
import ej.fp.FrontPanel;
import ej.fp.Image;

public abstract class Widget {
    public static final String DEFAULT_LABEL = "";
    private String label = "";
    private int x;
    private int y;
    private int width;
    private int height;
    private Image skin;
    private Image filter;
    private boolean overlay;
    private Composite composite;
    private Image currentSkin;

    public void setLabel(String string) {
        this.label = string == null ? DEFAULT_LABEL : string;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setWidth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Widget width cannot be negative.");
        }
        this.width = n;
    }

    public void setHeight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Widget height cannot be negative.");
        }
        this.height = n;
    }

    public void setSkin(Image image) {
        this.skin = image;
    }

    public void setFilter(Image image) {
        this.filter = image;
    }

    public final void setOverlay(boolean bl) {
        this.overlay = bl;
    }

    public synchronized void finalizeConfiguration() {
        Image image = this.getSkin();
        if (image != null) {
            this.width = image.getWidth();
            this.height = image.getHeight();
        }
        if ((image = this.filter) != null && (this.getHeight() != image.getHeight() || this.getWidth() != image.getWidth())) {
            throw new IllegalStateException("Filter image must have the same size than widget itself.");
        }
        this.currentSkin = this.skin;
    }

    public void showYourself(boolean bl) {
    }

    public void start() {
    }

    public void dispose() {
        FrontPanel.getFrontPanel().disposeIfNotNull(this.skin, this.currentSkin, this.filter);
        this.skin = null;
        this.currentSkin = null;
        this.filter = null;
    }

    public String getLabel() {
        return this.label;
    }

    public Image getSkin() {
        return this.skin;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getFilter() {
        return this.filter;
    }

    public boolean isOver(int n, int n2) {
        return this.isOverWidget(n, n2) && this.isOverFilter(n, n2);
    }

    public int getAbsoluteX() {
        Composite composite = this.getParent();
        if (composite == null) {
            return this.x;
        }
        return composite.getAbsoluteX() + this.x;
    }

    public int getAbsoluteY() {
        Composite composite = this.getParent();
        if (composite == null) {
            return this.y;
        }
        return composite.getAbsoluteY() + this.y;
    }

    public Composite getParent() {
        return this.composite;
    }

    public Image getCurrentSkin() {
        return this.currentSkin;
    }

    public void setCurrentSkin(Image image) {
        this.currentSkin = image;
        this.repaint();
    }

    public void repaint() {
        if (this.overlay) {
            FrontPanel.getFrontPanel().repaintWidget(this);
            return;
        }
        FrontPanel.getFrontPanel().repaintDevice(this.getAbsoluteX(), this.getAbsoluteY(), this.width, this.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        if (this.overlay) {
            FrontPanel.getFrontPanel().repaintWidget(this, n, n2, n3, n4);
            return;
        }
        FrontPanel.getFrontPanel().repaintDevice(this.getAbsoluteX() + n, this.getAbsoluteY() + n2, n3, n4);
    }

    void setParent(Composite composite) {
        this.composite = composite;
    }

    private boolean isOverWidget(int n, int n2) {
        return this.x <= n && this.y <= n2 && this.x + this.width > n && this.y + this.height > n2;
    }

    private boolean isOverFilter(int n, int n2) {
        try {
            Image image = this.filter;
            return image == null || (image.readPixel(n - this.getAbsoluteX(), n2 - this.getAbsoluteY()) & 0xFF000000) != 0;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }
}

