/*
 * Decompiled with CFR 0.152.
 */
package ej.fp;

import ej.fp.Device;
import ej.fp.Image;
import ej.fp.Widget;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.ServiceLoader;

public abstract class FrontPanel {
    public static final PrintStream out;
    private static final FrontPanel frontPanel;

    static {
        try {
            Iterator<FrontPanel> iterator = ServiceLoader.load(FrontPanel.class, FrontPanel.class.getClassLoader()).iterator();
            frontPanel = iterator.next();
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Cannot create instance of FrontPanel.");
        }
        out = frontPanel.getPrintStream();
        frontPanel.start();
    }

    public static FrontPanel getFrontPanel() {
        return frontPanel;
    }

    public abstract Device getDevice();

    protected abstract void start();

    protected abstract void onStop();

    public abstract Object getDeviceWidget();

    protected abstract PrintStream getPrintStream();

    public abstract void repaintDevice();

    public abstract void repaintDevice(int var1, int var2, int var3, int var4);

    public abstract void repaintWidget(Widget var1);

    public abstract void repaintWidget(Widget var1, int var2, int var3, int var4, int var5);

    public abstract Image newImage(InputStream var1);

    public abstract Image newImage(int var1, int var2, int var3, boolean var4);

    public Image newImage(Image image) {
        Image image2 = this.newImage(image.getWidth(), image.getHeight(), 0, true);
        image2.drawImage(image);
        return image2;
    }

    public void verifyUserClass(Class clazz, Class clazz2, String string) {
        this.getUserClass(clazz, clazz2, string);
    }

    public abstract Class getUserClass(Class var1, Class var2, String var3);

    public abstract Object newUserInstance(Class var1, Class var2, String var3);

    public abstract void checkVersion(String var1, String var2);

    public void disposeIfNotNull(Image ... object) {
        if (object != null) {
            Image[] imageArray = object;
            int n = ((Image[])object).length;
            int n2 = 0;
            while (n2 < n) {
                object = imageArray[n2];
                if (object != null) {
                    object.dispose();
                }
                ++n2;
            }
        }
    }
}

