/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.java.io;

import com.is2t.hil.HIL;
import com.is2t.java.io.FileSystem;
import ej.sni.NativeIOException;
import java.io.File;
import java.io.IOException;

public class UnixFileSystem {
    private static final char UNIX_LIKE_FILE_SEPARATOR = '/';

    public static void canonicalizeNative(byte[] path, byte[] canonicalizePath, int canonicalizePathLength) throws NativeIOException {
        String canonicalPath;
        File source = FileSystem.getMachineLocalFile(path);
        try {
            String rootDirStr;
            File rootDir;
            String rootDirCanonicalPath;
            canonicalPath = source.getCanonicalPath();
            if (File.separatorChar != '/') {
                canonicalPath = canonicalPath.replace(File.separatorChar, '/');
            }
            if ((canonicalPath = canonicalPath.substring((rootDirCanonicalPath = (rootDir = new File(rootDirStr = System.getProperty("fs.mock.root.dir"))).getCanonicalPath()).length(), canonicalPath.length())).equals("")) {
                canonicalPath = String.valueOf('/');
            }
        }
        catch (IOException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
        byte[] bytes = canonicalPath.getBytes();
        if (canonicalizePathLength < bytes.length) {
            throw new NativeIOException(-2, "canonicalizePath not large enough");
        }
        System.arraycopy(bytes, 0, canonicalizePath, 0, bytes.length);
        canonicalizePath[bytes.length] = 0;
        HIL.getInstance().flushContent((Object)canonicalizePath);
    }
}

