/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.java.io;

import com.is2t.hil.HIL;
import com.is2t.java.io.DefaultFileChannel;
import ej.sni.NativeException;
import ej.sni.NativeIOException;
import ej.sni.SNI;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class FileSystem {
    private static int NextDirectoryId = 0;
    private static Map<Integer, File> OpenedDirectories = new HashMap<Integer, File>();
    private static String[] ListedDirectoryFiles;
    private static int LastListedDirectoryFileIndex;
    private static final String MOCK_FS_ROOT_PROPERTY = "fs.mock.root.dir";
    private static final String MOCK_FS_MAX_PATH_LENGTH_PROPERTY = "fs.mock.max.path.length";
    public static final String WORKING_DIR;
    private static final int DEFAULT_MAX_PATH_LENGTH = 256;
    static final int LLFS_OK = 0;
    static final int LLFS_EOF = -1;
    static final int LLFS_NOK = -2;
    static final int LLFS_NOT_CREATED = -3;
    private static final int LLFS_ACCESS_READ = 4;
    private static final int LLFS_ACCESS_WRITE = 2;
    private static final int LLFS_ACCESS_EXECUTE = 1;
    private static final int LLFS_PERMISSION_OWNER_ONLY = 0;
    private static final int LLFS_PERMISSION_ALL = 1;
    private static final int LLFS_PERMISSION_ENABLE = 0;
    private static final int LLFS_PERMISSION_DISABLE = 1;
    private static final int INT_SIZE = 4;
    private static final int LLFS_date_t_offsetof_YEAR = 0;
    private static final int LLFS_date_t_offsetof_MONTH = 4;
    private static final int LLFS_date_t_offsetof_DAY = 8;
    private static final int LLFS_date_t_offsetof_HOUR = 12;
    private static final int LLFS_date_t_offsetof_MINUTE = 16;
    private static final int LLFS_date_t_offsetof_SECOND = 20;
    public static final int LLFS_FREE_SPACE = 0;
    public static final int LLFS_TOTAL_SPACE = 1;
    public static final int LLFS_USABLE_SPACE = 2;

    static {
        LastListedDirectoryFileIndex = -1;
        WORKING_DIR = System.getProperty(MOCK_FS_ROOT_PROPERTY);
    }

    public static void initializeNative() {
        if (WORKING_DIR == null) {
            throw new NativeException(-2, "Working directory path is not defined in property fs.mock.root.dir");
        }
        File workingDir = new File(WORKING_DIR);
        if (!workingDir.exists() && !new File(WORKING_DIR).mkdirs()) {
            throw new NativeException(-2, "Cannot create working directory " + WORKING_DIR);
        }
    }

    public static int lastModifiedNative(byte[] path, byte[] date) {
        long l = FileSystem.getMachineLocalFile(path).lastModified();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(l);
        FileSystem.writeInt(date, 20, c.get(13));
        FileSystem.writeInt(date, 16, c.get(12));
        FileSystem.writeInt(date, 12, c.get(11));
        FileSystem.writeInt(date, 8, c.get(5));
        FileSystem.writeInt(date, 4, c.get(2));
        FileSystem.writeInt(date, 0, c.get(1));
        HIL.getInstance().flushContent((Object)date);
        return 0;
    }

    public static int setReadOnlyNative(byte[] path) {
        return FileSystem.getMachineLocalFile(path).setReadOnly() ? 0 : -2;
    }

    public static int createNative(byte[] path) throws IOException {
        try {
            if (FileSystem.getMachineLocalFile(path).createNewFile()) {
                return 0;
            }
            return -3;
        }
        catch (IOException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized int opendirNative(byte[] path) {
        File f = FileSystem.getMachineLocalFile(path);
        if (f.exists() && f.isDirectory()) {
            int _id = NextDirectoryId++;
            OpenedDirectories.put(_id, f);
            return _id;
        }
        return -2;
    }

    public static int readdirNative(int dirID, byte[] path) {
        int ret = -2;
        File f = OpenedDirectories.get(dirID);
        if (f != null) {
            if (LastListedDirectoryFileIndex == -1) {
                ListedDirectoryFiles = f.list();
                if (ListedDirectoryFiles == null) {
                    ListedDirectoryFiles = new String[0];
                }
                LastListedDirectoryFileIndex = 0;
            }
            if (LastListedDirectoryFileIndex >= ListedDirectoryFiles.length) {
                ret = -2;
            } else {
                byte[] bytes = ListedDirectoryFiles[LastListedDirectoryFileIndex].getBytes();
                System.arraycopy(bytes, 0, path, 0, bytes.length);
                path[bytes.length] = 0;
                HIL.getInstance().flushContent((Object)path);
                ++LastListedDirectoryFileIndex;
                ret = 0;
            }
        }
        return ret;
    }

    public static int closedirNative(int dirID) {
        OpenedDirectories.remove(dirID);
        ListedDirectoryFiles = null;
        LastListedDirectoryFileIndex = -1;
        return 0;
    }

    public static int renameToNative(byte[] path, byte[] newPath) {
        HIL.getInstance().refreshContent((Object)newPath);
        File source = FileSystem.getMachineLocalFile(path);
        return source.renameTo(FileSystem.getMachineLocalFile(newPath)) ? 0 : -2;
    }

    public static long lengthNative(byte[] path) {
        return FileSystem.getMachineLocalFile(path).length();
    }

    public static int existNative(byte[] path) {
        File f = FileSystem.getMachineLocalFile(path);
        return f.exists() ? 0 : -2;
    }

    public static int mkdirNative(byte[] path) {
        File f = FileSystem.getMachineLocalFile(path);
        return f.mkdir() ? 0 : -2;
    }

    public static int isHiddenNative(byte[] path) {
        File f = FileSystem.getMachineLocalFile(path);
        return f.isHidden() ? 0 : -2;
    }

    public static int isDirectoryNative(byte[] path) {
        File f = FileSystem.getMachineLocalFile(path);
        return f.isDirectory() ? 0 : -2;
    }

    public static int isFileNative(byte[] path) {
        File f = FileSystem.getMachineLocalFile(path);
        return f.isFile() ? 0 : -2;
    }

    public static long getSpaceSizeNative(byte[] path, int spaceType) {
        File f = FileSystem.getMachineLocalFile(path);
        switch (spaceType) {
            case 0: {
                return f.getFreeSpace();
            }
            case 1: {
                return f.getTotalSpace();
            }
            case 2: {
                return f.getUsableSpace();
            }
        }
        throw new NativeException(spaceType, "Invalid space type " + spaceType);
    }

    public static int setLastModifiedNative(byte[] path, byte[] date) {
        File f = FileSystem.getMachineLocalFile(path);
        HIL.getInstance().refreshContent((Object)date);
        Calendar c = Calendar.getInstance();
        c.set(1, FileSystem.readInt(date, 0));
        c.set(2, FileSystem.readInt(date, 4));
        c.set(5, FileSystem.readInt(date, 8));
        c.set(11, FileSystem.readInt(date, 12));
        c.set(12, FileSystem.readInt(date, 16));
        c.set(13, FileSystem.readInt(date, 20));
        f.setLastModified(c.getTimeInMillis());
        return 0;
    }

    public static int deleteNative(byte[] path) {
        File f;
        block3: {
            f = FileSystem.getMachineLocalFile(path);
            try {
                if (!f.getCanonicalFile().equals(new File(WORKING_DIR).getCanonicalFile())) break block3;
                return -2;
            }
            catch (IOException iOException) {
                return -2;
            }
        }
        return f.delete() ? 0 : -2;
    }

    public static int checkAccessNative(byte[] path, int access) {
        File f = FileSystem.getMachineLocalFile(path);
        switch (access) {
            case 4: {
                return f.canRead() ? 0 : -2;
            }
            case 2: {
                return f.canWrite() ? 0 : -2;
            }
            case 1: {
                return f.canExecute() ? 0 : -2;
            }
        }
        return -2;
    }

    public static int setPermissionNative(byte[] path, int access, int enable, int owner) {
        File f = FileSystem.getMachineLocalFile(path);
        switch (access) {
            case 4: {
                return f.setReadable(enable == 0, owner == 0) ? 0 : -2;
            }
            case 2: {
                return f.setWritable(enable == 0, owner == 0) ? 0 : -2;
            }
            case 1: {
                return f.setExecutable(enable == 0, owner == 0) ? 0 : -2;
            }
        }
        return -2;
    }

    static File getMachineLocalFile(byte[] jpfAbsolutePath) {
        HIL.getInstance().refreshContent((Object)jpfAbsolutePath);
        String p = SNI.toJavaString((byte[])jpfAbsolutePath);
        File f = new File(p);
        try {
            p = f.getCanonicalPath();
            if (p.startsWith("/..")) {
                f = new File(p);
                p = f.getCanonicalPath();
            }
        }
        catch (IOException iOException) {}
        p = p.substring(p.indexOf(File.separatorChar));
        p = String.valueOf(WORKING_DIR) + p;
        return new File(p);
    }

    public static int openNative(byte[] path, char mode) throws IOException {
        return DefaultFileChannel.openNative(path, mode);
    }

    public static int readByteNative(int fd) throws IOException {
        return DefaultFileChannel.readByteNative(fd);
    }

    public static int readNative(int fd, byte[] data, int offset, int length) throws IOException {
        return DefaultFileChannel.readNative(fd, data, offset, length);
    }

    public static void seekNative(int fd, long n) throws IOException {
        DefaultFileChannel.seekNative(fd, n);
    }

    public static long getFilePointerNative(int fd) throws IOException {
        return DefaultFileChannel.getFilePointerNative(fd);
    }

    public static void setLengthNative(int fd, long newLength) throws IOException {
        DefaultFileChannel.setLengthNative(fd, newLength);
    }

    public static long lengthWithFdNative(int fd) throws IOException {
        return DefaultFileChannel.lengthWithFdNative(fd);
    }

    public static int availableNative(int fd) throws IOException {
        return DefaultFileChannel.availableNative(fd);
    }

    public static void closeNative(int fd) throws IOException {
        DefaultFileChannel.closeNative(fd);
    }

    public static int writeNative(int fileID, byte[] data, int off, int length) throws IOException {
        return DefaultFileChannel.writeNative(fileID, data, off, length);
    }

    public static void writeByteNative(int fd, int data) throws IOException {
        DefaultFileChannel.writeByteNative(fd, data);
    }

    public static void flushNative(int fd) throws IOException {
        DefaultFileChannel.flushNative(fd);
    }

    public static int getMaxPathLength() {
        return Integer.getInteger(MOCK_FS_MAX_PATH_LENGTH_PROPERTY, 256);
    }

    private static void writeInt(byte[] array, int offset, int value) {
        int bLL = value >> 24 & 0xFF;
        int bLH = value >> 16 & 0xFF;
        int bHL = value >> 8 & 0xFF;
        int bHH = value & 0xFF;
        array[offset] = (byte)bHH;
        array[offset + 1] = (byte)bHL;
        array[offset + 2] = (byte)bLH;
        array[offset + 3] = (byte)bLL;
    }

    public static int readInt(byte[] array, int offset) {
        int bLL = array[offset] & 0xFF;
        int bLH = array[offset + 1] & 0xFF;
        int bHL = array[offset + 2] & 0xFF;
        int bHH = array[offset + 3] & 0xFF;
        return bHH << 24 | bHL << 16 | bLH << 8 | bLL;
    }
}

