/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.java.io;

import com.is2t.hil.HIL;
import com.is2t.java.io.FileSystem;
import ej.sni.NativeIOException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.NonWritableChannelException;
import java.util.HashMap;
import java.util.Map;

public class DefaultFileChannel {
    private static final String INVALID_FILE_DESCRIPTOR = "Invalid file descriptor ";
    private static final char LLFS_FILE_MODE_READ = 'R';
    private static final char LLFS_FILE_MODE_WRITE = 'W';
    private static final char LLFS_FILE_MODE_READ_WRITE = 'B';
    public static final char FILE_MODE_READ_WRITE_DSYNC = 'D';
    public static final char FILE_MODE_READ_WRITE_SYNC = 'S';
    private static final char LLFS_FILE_MODE_APPEND = 'A';
    private static int NextFileDescriptor = 0;
    private static Map<Integer, FileChannel> FileChannels = new HashMap<Integer, FileChannel>();

    public static int openNative(byte[] path, char mode) throws NativeIOException {
        File f = FileSystem.getMachineLocalFile(path);
        int fd = NextFileDescriptor++;
        try {
            FileChannel fch = null;
            switch (mode) {
                case 'R': {
                    fch = new FileInputStream(f).getChannel();
                    break;
                }
                case 'A': 
                case 'W': {
                    fch = new FileOutputStream(f, mode == 'A').getChannel();
                    break;
                }
                case 'B': {
                    fch = new RandomAccessFile(f, "rw").getChannel();
                    break;
                }
                case 'D': {
                    fch = new RandomAccessFile(f, "rwd").getChannel();
                    break;
                }
                case 'S': {
                    fch = new RandomAccessFile(f, "rws").getChannel();
                    break;
                }
                default: {
                    throw new NativeIOException(-2, "unknwon mode");
                }
            }
            FileChannels.put(fd, fch);
        }
        catch (IOException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
        return fd;
    }

    public static int writeNative(int fileID, byte[] data, int off, int length) throws NativeIOException {
        FileChannel fch = FileChannels.get(fileID);
        if (fch == null) {
            throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fileID);
        }
        try {
            HIL.getInstance().refreshContent((Object)data, off, length);
            ByteBuffer b = ByteBuffer.wrap(data, off, length);
            return fch.write(b);
        }
        catch (IOException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
    }

    public static void writeByteNative(int fd, int data) throws NativeIOException {
        FileChannel fch = FileChannels.get(fd);
        if (fch == null) {
            throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fd);
        }
        try {
            ByteBuffer b = ByteBuffer.wrap(new byte[]{(byte)data});
            fch.write(b);
        }
        catch (IOException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
    }

    public static int readNative(int fd, byte[] data, int offset, int dataLength) throws IOException {
        FileChannel fch = FileChannels.get(fd);
        if (fch == null) {
            throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fd);
        }
        try {
            ByteBuffer b = ByteBuffer.wrap(data, offset, dataLength);
            int res = fch.read(b);
            if (res != -1) {
                HIL.getInstance().flushContent((Object)data, offset, res);
            }
            return res;
        }
        catch (IOException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
    }

    public static int readByteNative(int fd) throws NativeIOException {
        ByteBuffer b;
        block4: {
            FileChannel fch = FileChannels.get(fd);
            if (fch == null) {
                throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fd);
            }
            try {
                b = ByteBuffer.allocate(1);
                if (fch.read(b) != -1) break block4;
                return -1;
            }
            catch (IOException e) {
                throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
            }
        }
        return b.get(0) & 0xFF;
    }

    public static void closeNative(int fd) throws NativeIOException {
        Map<Integer, FileChannel> map = FileChannels;
        Closeable stream = map.get(fd);
        if (stream == null) {
            map = FileChannels;
            stream = map.get(fd);
        }
        if (stream != null) {
            map.remove(fd);
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
            }
        } else {
            throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fd);
        }
    }

    public static int availableNative(int fd) throws NativeIOException {
        FileChannel fch;
        block4: {
            fch = FileChannels.get(fd);
            if (fch == null) {
                throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fd);
            }
            try {
                if (fch.size() >= fch.position()) break block4;
                return 0;
            }
            catch (Exception e) {
                throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
            }
        }
        return (int)(fch.size() - fch.position());
    }

    public static void flushNative(int fd) throws NativeIOException {
        FileChannel fch = FileChannels.get(fd);
        if (fch == null) {
            throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fd);
        }
        try {
            fch.force(true);
        }
        catch (IOException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
    }

    public static void seekNative(int fd, long n) throws NativeIOException {
        FileChannel fch = FileChannels.get(fd);
        if (fch == null) {
            throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fd);
        }
        try {
            fch.position(n);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
    }

    public static long getFilePointerNative(int fd) throws NativeIOException {
        FileChannel fch = FileChannels.get(fd);
        if (fch == null) {
            throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fd);
        }
        try {
            return fch.position();
        }
        catch (IOException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
    }

    public static void setLengthNative(int fd, long newLength) throws NativeIOException {
        FileChannel fch = FileChannels.get(fd);
        if (fch == null) {
            throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fd);
        }
        try {
            long size = fch.size();
            if (newLength > size) {
                long position = fch.position();
                fch.write(ByteBuffer.allocate((int)(newLength - size)), position);
            } else {
                fch.truncate(newLength);
            }
        }
        catch (IOException | NonWritableChannelException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
    }

    public static long lengthWithFdNative(int fd) throws NativeIOException {
        FileChannel fch = FileChannels.get(fd);
        if (fch == null) {
            throw new NativeIOException(-2, INVALID_FILE_DESCRIPTOR + fd);
        }
        try {
            return fch.size();
        }
        catch (IOException e) {
            throw new NativeIOException(-2, e.getMessage(), (Throwable)e);
        }
    }
}

