/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.soar.bcv;

import com.is2t.soar.bcv.BytecodeVerifierClasspath;
import com.is2t.soar.bcv.IBytecodeVerifier;
import com.is2t.soar.bcv.VerificationResult;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;

public class BytecodeVerifierBCEL
implements IBytecodeVerifier {
    public BytecodeVerifierBCEL() {
        this.setClasspath("");
    }

    public void setClasspath(String classpath) {
        SyntheticRepository repo = SyntheticRepository.getInstance((ClassPath)new BytecodeVerifierClasspath(classpath));
        org.apache.bcel.Repository.setRepository((Repository)repo);
    }

    public VerificationResult verify(String classname) {
        return this.verify(classname, false);
    }

    public VerificationResult verify(String classname, boolean ignoreMissingClasses) {
        JavaClass jc;
        try {
            jc = org.apache.bcel.Repository.lookupClass((String)classname);
        }
        catch (Throwable e) {
            return new VerificationResult(VerificationResult.Status.REJECTED, e.getMessage());
        }
        VerifierFactory.flush();
        Verifier verifier = VerifierFactory.getVerifier((String)classname, (boolean)ignoreMissingClasses);
        return this.verify(jc, verifier);
    }

    public VerificationResult verify(byte[] bytecode) {
        return this.verify(bytecode, false);
    }

    public VerificationResult verify(byte[] bytecode, boolean ignoreMissingClasses) {
        JavaClass jc;
        try {
            jc = new ClassParser(bytecode).parse();
        }
        catch (Throwable e) {
            return new VerificationResult(VerificationResult.Status.REJECTED, e.getMessage());
        }
        VerifierFactory.flush();
        Verifier verifier = VerifierFactory.getVerifier((byte[])bytecode, (boolean)ignoreMissingClasses);
        return this.verify(jc, verifier);
    }

    private VerificationResult verify(JavaClass jc, Verifier verifier) {
        verifier.flush();
        StringBuilder message = new StringBuilder();
        try {
            if (this.checkResultError(verifier.doPass1(), message)) {
                return new VerificationResult(VerificationResult.Status.REJECTED, message.toString());
            }
            if (this.checkResultError(verifier.doPass2(), message)) {
                return new VerificationResult(VerificationResult.Status.REJECTED, message.toString());
            }
            int i = 0;
            while (i < jc.getMethods().length) {
                if (this.checkResultError(verifier.doPass3a(i), message)) {
                    return new VerificationResult(VerificationResult.Status.REJECTED, message.toString());
                }
                if (this.checkResultError(verifier.doPass3b(i), message)) {
                    return new VerificationResult(VerificationResult.Status.REJECTED, message.toString());
                }
                ++i;
            }
        }
        catch (Throwable t) {
            return new VerificationResult(VerificationResult.Status.REJECTED, t.getMessage());
        }
        return new VerificationResult(VerificationResult.Status.OK, "Verification passed.");
    }

    public boolean checkResultError(org.apache.bcel.verifier.VerificationResult vr, StringBuilder message) {
        if (vr.getStatus() != 1) {
            message.append(vr.getMessage()).append('\n');
            return true;
        }
        return false;
    }
}

