/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.classpath;

import com.is2t.classpath.EntryFilter;
import com.is2t.classpath.FileClasspath;
import com.is2t.classpath.InputStreamWrapper;
import com.is2t.classpath.StopListException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class JarClasspath
extends FileClasspath {
    public JarClasspath(File path) {
        super(path);
    }

    @Override
    public String toStringFilename(String relativeEntry) {
        return this.file.getAbsolutePath() + '[' + relativeEntry + ']';
    }

    @Override
    public InputStream getInputStream(String entry) {
        ZipFile jf = null;
        try {
            jf = new JarFile(this.file, false);
            Enumeration<JarEntry> entries = ((JarFile)jf).entries();
            while (entries.hasMoreElements()) {
                String entryName;
                JarEntry e = entries.nextElement();
                if (e.isDirectory() || !(entryName = e.getName()).equals(entry)) continue;
                return new InputStreamWrapper(jf, ((JarFile)jf).getInputStream(e));
            }
        }
        catch (Exception e) {
            try {
                jf.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] list(EntryFilter filter, boolean directory) {
        ArrayList<String> entriesVect = new ArrayList<String>();
        JarFile jf = null;
        try {
            jf = new JarFile(this.file, false);
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                boolean result;
                JarEntry e = entries.nextElement();
                if (directory != e.isDirectory()) continue;
                String entry = e.getName();
                if (entry.endsWith("/")) {
                    entry = entry.substring(0, entry.length() - 1);
                }
                try {
                    result = filter.accept(entry);
                }
                catch (StopListException ex) {
                    break;
                }
                catch (Throwable t) {
                    result = false;
                }
                if (!result) continue;
                entriesVect.add(entry);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException ignored) {}
            }
        }
        return entriesVect.toArray(new String[entriesVect.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String relativeEntry) {
        ZipFile jf = null;
        try {
            jf = new JarFile(this.file, false);
            Enumeration<JarEntry> entries = ((JarFile)jf).entries();
            while (true) {
                if (entries.hasMoreElements()) {
                    JarEntry e = entries.nextElement();
                    if (e.isDirectory()) continue;
                    String entry = e.getName();
                    if (!relativeEntry.equals(entry)) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                jf.close();
            }
            catch (IOException ignored) {}
        }
        return false;
    }
}

