/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.classpath;

import com.is2t.classpath.EntryFilter;
import com.is2t.classpath.FileClasspath;
import com.is2t.classpath.StopListException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class DirClasspath
extends FileClasspath {
    public DirClasspath(File path) {
        super(path);
    }

    @Override
    public boolean exists(String relativeEntry) {
        return new File(this.file, relativeEntry).exists();
    }

    @Override
    public String toStringFilename(String relativeEntry) {
        return this.file.getAbsolutePath() + '/' + relativeEntry;
    }

    @Override
    public InputStream getInputStream(String relativeEntry) {
        try {
            return new FileInputStream(new File(this.file, relativeEntry));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String[] list(EntryFilter filter, boolean directory) {
        ArrayList<String> entriesVect = new ArrayList<String>();
        try {
            this.list0(this.file, filter, directory, entriesVect);
        }
        catch (StopListException e) {
            // empty catch block
        }
        return entriesVect.toArray(new String[entriesVect.size()]);
    }

    private void list0(File rootDir, EntryFilter filter, boolean directory, ArrayList<String> entriesVect) {
        File[] files = rootDir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (directory == f.isDirectory()) {
                boolean result;
                String entry = f.getAbsolutePath().substring(this.file.getAbsolutePath().length() + 1).replace(File.separatorChar, '/');
                try {
                    result = filter.accept(entry);
                }
                catch (StopListException e) {
                    throw e;
                }
                catch (Throwable e) {
                    result = false;
                }
                if (result) {
                    entriesVect.add(entry);
                }
            }
            if (!f.isDirectory()) continue;
            this.list0(f, filter, directory, entriesVect);
        }
    }
}

