/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.classpath;

import com.is2t.classpath.DirClasspath;
import com.is2t.classpath.FileClasspath;
import com.is2t.classpath.JarClasspath;
import java.io.File;
import java.util.ArrayList;

public class ClasspathLoader {
    public static FileClasspath[] loadClasspath(String classpath, char separator) {
        return ClasspathLoader.loadClasspath(ClasspathLoader.splitAndRemoveEmpty(classpath, separator));
    }

    public static String[] splitAndRemoveEmpty(String path, char separator) {
        return ClasspathLoader.removeEmptyElement(path.split(String.valueOf(separator)));
    }

    public static FileClasspath[] loadClasspath(String[] classpath) {
        ArrayList<JarClasspath> classpathVect = new ArrayList<JarClasspath>();
        for (String currentPath : classpath) {
            FileClasspath fsc;
            File fsPath = new File(currentPath);
            if (!fsPath.exists()) continue;
            if (ClasspathLoader.endsWithJarExtension(currentPath)) {
                fsc = new JarClasspath(fsPath);
            } else {
                if (!fsPath.isDirectory()) continue;
                fsc = new DirClasspath(fsPath);
            }
            classpathVect.add((JarClasspath)fsc);
        }
        return classpathVect.toArray(new FileClasspath[classpathVect.size()]);
    }

    public static String joinElements(String[] elements, String separator) {
        StringBuilder result = new StringBuilder();
        int lastElementIndex = elements.length - 1;
        for (int i = 0; i < lastElementIndex; ++i) {
            result.append(elements[i]);
            result.append(separator);
        }
        if (lastElementIndex >= 0) {
            result.append(elements[lastElementIndex]);
        }
        return result.toString();
    }

    private static boolean endsWithJarExtension(String path) {
        return path.endsWith(".jar");
    }

    private static String[] removeEmptyElement(String[] strings) {
        int nb = 0;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].length() == 0) continue;
            ++nb;
        }
        if (nb == strings.length) {
            return strings;
        }
        String[] stringsWithoutEmpty = new String[nb];
        int ptr = -1;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].length() == 0) continue;
            stringsWithoutEmpty[++ptr] = strings[i];
        }
        return stringsWithoutEmpty;
    }
}

