/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wearable.kernel.external;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ExternalResourcesManager {
    private static final String DIR_PROPERTY = "externalResources.output.dir";

    private ExternalResourcesManager() {
    }

    public static byte[] getExternalResource(String path) throws IOException {
        File file = new File(ExternalResourcesManager.getDir(), path);
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            System.out.println("Returning resource " + path + " from external resources");
            int size = (int)file.length();
            byte[] data = new byte[size];
            new DataInputStream(inputStream).readFully(data);
            return data;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static File getDir() {
        String dirPath = System.getProperty(DIR_PROPERTY);
        if (dirPath == null) {
            throw new RuntimeException("Property externalResources.output.dir is not set");
        }
        File dir = new File(dirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException("Property externalResources.output.dir does not point to a valid directory");
        }
        return dir;
    }
}

