/*
 * Decompiled with CFR 0.152.
 */
package com.microej.painter;

import com.is2t.hil.HIL;
import com.microej.painter.BlendModeUtils;
import com.microej.painter.MultiplyComposite;
import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImage;
import ej.microui.display.MicroUIImageFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class TransformedImagePainterNatives {
    private TransformedImagePainterNatives() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(byte[] target, byte[] source, int regionX, int regionY, int regionWidth, int regionHeight, int x, int y, float[] matrix, boolean bilinear, int alpha, int blend) {
        LLUIDisplay engine;
        HIL.getInstance().refreshContent((Object)matrix, 0, 9);
        LLUIDisplay lLUIDisplay = engine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = engine.mapMicroUIGraphicsContext(target);
            MicroUIImage image = engine.mapMicroUIImage(source);
            if (gc.requestDrawing() && !image.isClosed() && !engine.isCustomFormat(gc.getFormat()) && !engine.isCustomFormat(image.getFormat()) && alpha > 0) {
                BufferedImage bi = (BufferedImage)gc.getImage().getRAWImage();
                Graphics2D g2d = bi.createGraphics();
                ej.fp.Image colorizedImage = image.getImage(gc.getMicroUIColor());
                BufferedImage img = TransformedImagePainterNatives.getTransparentImage((BufferedImage)colorizedImage.getRAWImage(), alpha);
                if (regionX < 0) {
                    regionWidth += regionX;
                    x -= regionX;
                    regionX = 0;
                }
                if (regionY < 0) {
                    regionHeight += regionY;
                    y -= regionY;
                    regionY = 0;
                }
                regionWidth = Math.min(regionWidth, image.getWidth() - regionX);
                regionHeight = Math.min(regionHeight, image.getHeight() - regionY);
                if (regionWidth > 0 && regionHeight > 0) {
                    int color;
                    MicroUIImageFormat format;
                    if (regionX != 0 || regionY != 0 || regionWidth != image.getWidth() || regionHeight != image.getHeight()) {
                        img = img.getSubimage(regionX, regionY, regionWidth, regionHeight);
                    }
                    if ((format = image.getFormat()) != MicroUIImageFormat.MICROUI_IMAGE_FORMAT_A8 && (color = gc.getMicroUIColor()) != 0xFFFFFF) {
                        img = TransformedImagePainterNatives.colorizeImage(img, color);
                    }
                    AffineTransform transform = TransformedImagePainterNatives.getAffineTransform(matrix, x, y);
                    g2d.setComposite(BlendModeUtils.getComposite(blend));
                    Object interpolation = bilinear ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
                    g2d.setClip(gc.getClipX1(), gc.getClipY1(), gc.getClipX2() + 1 - gc.getClipX1(), gc.getClipY2() + 1 - gc.getClipY1());
                    g2d.drawImage(img, transform, null);
                }
            }
        }
    }

    private static BufferedImage getTransparentImage(BufferedImage image, int alpha) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Graphics2D g = newImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
        g.drawImage((Image)image, 0, 0, null);
        return newImage;
    }

    private static BufferedImage colorizeImage(BufferedImage image, int color) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Graphics2D g = newImage.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.setComposite(MultiplyComposite.INSTANCE);
        g.setColor(new Color(color));
        g.fillRect(0, 0, width, height);
        return newImage;
    }

    private static AffineTransform getAffineTransform(float[] matrix, float tx, float ty) {
        AffineTransform t = new AffineTransform();
        t.translate(tx, ty);
        t.concatenate(new AffineTransform(new float[]{matrix[0], matrix[3], matrix[1], matrix[4], matrix[2], matrix[5]}));
        return t;
    }
}

