/*
 * Decompiled with CFR 0.152.
 */
package com.microej.painter;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class MultiplyComposite
implements Composite {
    public static final MultiplyComposite INSTANCE = new MultiplyComposite();

    private MultiplyComposite() {
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new BlendingContext();
    }

    private static class BlendingContext
    implements CompositeContext {
        private BlendingContext() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            int width = Math.min(src.getWidth(), dstIn.getWidth());
            int height = Math.min(src.getHeight(), dstIn.getHeight());
            int[] srcRow = new int[width];
            int[] dstRow = new int[width];
            int[] resultRow = new int[width];
            int y = 0;
            while (y < height) {
                src.getDataElements(0, y, width, 1, srcRow);
                dstIn.getDataElements(0, y, width, 1, dstRow);
                int x = 0;
                while (x < width) {
                    resultRow[x] = BlendingContext.multiplyColors(srcRow[x], dstRow[x]);
                    ++x;
                }
                dstOut.setDataElements(0, y, width, 1, resultRow);
                ++y;
            }
        }

        private static int multiplyColors(int srcColor, int dstColor) {
            int srcRed = srcColor >> 16 & 0xFF;
            int dstRed = dstColor >> 16 & 0xFF;
            int srcGreen = srcColor >> 8 & 0xFF;
            int dstGreen = dstColor >> 8 & 0xFF;
            int srcBlue = srcColor & 0xFF;
            int dstBlue = dstColor & 0xFF;
            int resultAlpha = dstColor >> 24 & 0xFF;
            int resultRed = srcRed * dstRed / 255;
            int resultGreen = srcGreen * dstGreen / 255;
            int resultBlue = srcBlue * dstBlue / 255;
            return resultAlpha << 24 | resultRed << 16 | resultGreen << 8 | resultBlue;
        }
    }
}

