/*
 * Decompiled with CFR 0.152.
 */
package com.microej.painter;

import com.microej.painter.BlendComposite;
import java.awt.Composite;

class BlendModeUtils {
    private static final int BLEND_SRC = 0;
    private static final int BLEND_SRC_OVER = 1;
    private static final int BLEND_DST_OVER = 2;
    private static final int BLEND_SRC_IN = 3;
    private static final int BLEND_DST_IN = 4;
    private static final int BLEND_DST_OUT = 5;
    private static final int BLEND_PLUS = 6;
    private static final int BLEND_SCREEN = 7;
    private static final int BLEND_MULTIPLY = 8;

    private BlendModeUtils() {
    }

    public static Composite getComposite(int blend) {
        switch (blend) {
            case 0: {
                return BlendComposite.SRC;
            }
            case 1: {
                return BlendComposite.SRC_OVER;
            }
            case 2: {
                return BlendComposite.DST_OVER;
            }
            case 3: {
                return BlendComposite.SRC_IN;
            }
            case 4: {
                return BlendComposite.DST_IN;
            }
            case 5: {
                return BlendComposite.DST_OUT;
            }
            case 6: {
                return BlendComposite.PLUS;
            }
            case 7: {
                return BlendComposite.SCREEN;
            }
            case 8: {
                return BlendComposite.MULTIPLY;
            }
        }
        throw new IllegalArgumentException("Unsupported blend mode: " + blend);
    }
}

