/*
 * Decompiled with CFR 0.152.
 */
package com.microej.painter;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

enum BlendComposite implements Composite
{
    SRC{

        @Override
        public void blend(int[] src, int[] dst, int[] result) {
            int i = 0;
            while (i < 4) {
                result[i] = src[i];
                ++i;
            }
        }
    }
    ,
    SRC_OVER{

        @Override
        public void blend(int[] src, int[] dst, int[] result) {
            int i = 0;
            while (i < 4) {
                result[i] = src[i] + (255 - src[3]) * dst[i] / 255;
                ++i;
            }
        }
    }
    ,
    DST_OVER{

        @Override
        protected void blend(int[] src, int[] dst, int[] result) {
            int i = 0;
            while (i < 4) {
                result[i] = dst[i] + (255 - dst[3]) * src[i] / 255;
                ++i;
            }
        }
    }
    ,
    SRC_IN{

        @Override
        protected void blend(int[] src, int[] dst, int[] result) {
            int i = 0;
            while (i < 4) {
                result[i] = src[i] * dst[3] / 255;
                ++i;
            }
        }
    }
    ,
    DST_IN{

        @Override
        protected void blend(int[] src, int[] dst, int[] result) {
            int i = 0;
            while (i < 4) {
                result[i] = dst[i] * src[3] / 255;
                ++i;
            }
        }
    }
    ,
    DST_OUT{

        @Override
        protected void blend(int[] src, int[] dst, int[] result) {
            int i = 0;
            while (i < 4) {
                result[i] = dst[i] * (255 - src[3]) / 255;
                ++i;
            }
        }
    }
    ,
    PLUS{

        @Override
        protected void blend(int[] src, int[] dst, int[] result) {
            int i = 0;
            while (i < 4) {
                result[i] = Math.min(src[i] + dst[i], 255);
                ++i;
            }
        }
    }
    ,
    SCREEN{

        @Override
        protected void blend(int[] src, int[] dst, int[] result) {
            int i = 0;
            while (i < 4) {
                result[i] = src[i] + dst[i] - src[i] * dst[i] / 255;
                ++i;
            }
        }
    }
    ,
    MULTIPLY{

        @Override
        protected void blend(int[] src, int[] dst, int[] result) {
            int i = 0;
            while (i < 3) {
                result[i] = src[i] * (255 - dst[3]) / 255 + dst[i] * (255 - src[3]) / 255 + src[i] * dst[i] / 255;
                ++i;
            }
            result[3] = src[3] + dst[3] - src[3] * dst[3] / 255;
        }
    };


    private BlendComposite() {
    }

    protected abstract void blend(int[] var1, int[] var2, int[] var3);

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        if (!BlendComposite.checkComponentsOrder(srcColorModel) || !BlendComposite.checkComponentsOrder(dstColorModel)) {
            throw new IllegalArgumentException("Unsupported color model");
        }
        return new BlendingContext(srcColorModel, dstColorModel);
    }

    private static boolean checkComponentsOrder(ColorModel colorModel) {
        if (colorModel instanceof DirectColorModel && colorModel.getTransferType() == 3) {
            DirectColorModel cm = (DirectColorModel)colorModel;
            return cm.getRedMask() == 0xFF0000 && cm.getGreenMask() == 65280 && cm.getBlueMask() == 255 && (cm.getNumComponents() != 4 || cm.getAlphaMask() == -16777216);
        }
        return false;
    }

    /* synthetic */ BlendComposite(String string, int n, BlendComposite blendComposite) {
        this();
    }

    private class BlendingContext
    implements CompositeContext {
        private final boolean transparentSrc;
        private final boolean transparentDst;
        private final boolean premultipliedSrc;
        private final boolean premultipliedDst;

        public BlendingContext(ColorModel srcColorModel, ColorModel dstColorModel) {
            this.transparentSrc = srcColorModel.hasAlpha();
            this.transparentDst = dstColorModel.hasAlpha();
            this.premultipliedSrc = srcColorModel.isAlphaPremultiplied();
            this.premultipliedDst = dstColorModel.isAlphaPremultiplied();
        }

        @Override
        public void dispose() {
        }

        @Override
        public void compose(Raster srcRaster, Raster dstRaster, WritableRaster resultRaster) {
            int width = Math.min(srcRaster.getWidth(), dstRaster.getWidth());
            int height = Math.min(srcRaster.getHeight(), dstRaster.getHeight());
            int[] srcRow = new int[width];
            int[] dstRow = new int[width];
            int[] resultRow = new int[width];
            int[] srcColor = new int[4];
            int[] dstColor = new int[4];
            int[] resultColor = new int[4];
            int y = 0;
            while (y < height) {
                srcRaster.getDataElements(0, y, width, 1, srcRow);
                dstRaster.getDataElements(0, y, width, 1, dstRow);
                int x = 0;
                while (x < width) {
                    int i;
                    int color = srcRow[x];
                    srcColor[0] = color >> 16 & 0xFF;
                    srcColor[1] = color >> 8 & 0xFF;
                    srcColor[2] = color & 0xFF;
                    srcColor[3] = color >> 24 & 0xFF;
                    color = dstRow[x];
                    dstColor[0] = color >> 16 & 0xFF;
                    dstColor[1] = color >> 8 & 0xFF;
                    dstColor[2] = color & 0xFF;
                    dstColor[3] = color >> 24 & 0xFF;
                    if (!this.transparentSrc) {
                        srcColor[3] = 255;
                    } else if (!this.premultipliedSrc && srcColor[3] != 255) {
                        i = 0;
                        while (i < 3) {
                            srcColor[i] = srcColor[i] * srcColor[3] / 255;
                            ++i;
                        }
                    }
                    if (!this.transparentDst) {
                        dstColor[3] = 255;
                    } else if (!this.premultipliedDst && dstColor[3] != 255) {
                        i = 0;
                        while (i < 3) {
                            dstColor[i] = dstColor[i] * dstColor[3] / 255;
                            ++i;
                        }
                    }
                    BlendComposite.this.blend(srcColor, dstColor, resultColor);
                    if (!this.transparentDst) {
                        resultColor[3] = 255;
                    } else if (!this.premultipliedDst && resultColor[3] != 255 && resultColor[3] != 0) {
                        i = 0;
                        while (i < 3) {
                            resultColor[i] = resultColor[i] * 255 / resultColor[3];
                            ++i;
                        }
                    }
                    resultRow[x] = (resultColor[3] & 0xFF) << 24 | (resultColor[0] & 0xFF) << 16 | (resultColor[1] & 0xFF) << 8 | resultColor[2] & 0xFF;
                    ++x;
                }
                resultRaster.setDataElements(0, y, width, 1, resultRow);
                ++y;
            }
        }
    }
}

