/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.validator;

import com.is2t.microej.workbench.ext.SharedMessages;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.ext.validator.IntOptionValidator;
import org.eclipse.osgi.util.NLS;

public class UIntIntervalOptionValidator
extends IntOptionValidator {
    long minValue;
    long maxValue;
    boolean checkOnlyMinValue;
    boolean checkOnlyMaxValue;

    public UIntIntervalOptionValidator(String label, int value, boolean checkOnlyMinValue) {
        super(label);
        this.minValue = (long)value & 0xFFFFFFFFL;
        this.checkOnlyMinValue = checkOnlyMinValue;
        this.checkOnlyMaxValue = !checkOnlyMinValue;
    }

    public UIntIntervalOptionValidator(String label, int minValue, int maxValue) {
        super(label);
        this.minValue = (long)minValue & 0xFFFFFFFFL;
        this.maxValue = (long)maxValue & 0xFFFFFFFFL;
        this.checkOnlyMaxValue = false;
        this.checkOnlyMinValue = false;
    }

    @Override
    public String validate(String text) {
        long value = (long)Tools.parseInt(text) & 0xFFFFFFFFL;
        if (this.checkOnlyMinValue) {
            if (value < this.minValue) {
                return NLS.bind((String)SharedMessages.ErrorIntervalOptionValidatorMin, (Object[])new Object[]{this.label, Long.toString(this.minValue)});
            }
        } else if (this.checkOnlyMaxValue) {
            if (value > this.maxValue) {
                return NLS.bind((String)SharedMessages.ErrorIntervalOptionValidatorMax, (Object[])new Object[]{this.label, Long.toString(this.maxValue)});
            }
        } else if (value < this.minValue || value > this.maxValue) {
            return NLS.bind((String)SharedMessages.ErrorIntervalOptionValidator, (Object[])new Object[]{this.label, Long.toString(this.minValue), Long.toString(this.maxValue)});
        }
        return null;
    }
}

