/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.lib.pap;

import com.is2t.microej.workbench.ext.CommonMessages;
import com.is2t.microej.workbench.ext.Page2;
import com.is2t.microej.workbench.ext.pages.lib.ESRConstants;
import com.is2t.microej.workbench.ext.pages.lib.ESRMessages;
import com.is2t.microej.workbench.ext.pages.lib.PAPPage;
import com.is2t.microej.workbench.ext.validator.FileOptionValidator;
import com.is2t.microej.workbench.std.launch.ext.BrowseOption;
import com.is2t.microej.workbench.std.launch.ext.ButtonInputText;
import com.is2t.microej.workbench.std.launch.ext.ButtonRemove;
import com.is2t.microej.workbench.std.launch.ext.ButtonUpDown;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.ListButton;
import com.is2t.microej.workbench.std.launch.ext.ListOption;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class FileLUNPage
extends Page2
implements ESRConstants {
    public FileLUNPage() {
        super(PAPPage.class);
    }

    @Override
    protected Group getCategoryPageGroup() {
        IInputValidator numberValidator = new IInputValidator(){

            public String isValid(String input) {
                try {
                    Integer.parseInt(input);
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return "Please enter a number";
                }
            }
        };
        ListOption sizes = new ListOption((ILabel)new StringLabel("LUNs size"), "ej.pap.lun.size", new ListButton[]{new ButtonInputText(1, "Add new LUN", "LUN size (bytes)", numberValidator), new ButtonInputText(2, "Change LUN size", "LUN size (bytes)", numberValidator){

            protected String openDialog(Shell s, String initialValue) {
                return super.openDialog(s, initialValue.replaceFirst("LUN \\d*: (\\d*) bytes", "$1"));
            }
        }, new ButtonUpDown(true), new ButtonUpDown(false), new ButtonRemove()}, 0, ";");
        sizes.minNbLines = 5;
        class ListOptionChangedListener
        implements OptionChangedListener {
            private ListOption sizes;

            public ListOptionChangedListener(ListOption truc) {
                this.sizes = truc;
            }

            public void changed() {
                List list = this.sizes.listWidget;
                int[] sel = list.getSelectionIndices();
                String[] items = list.getItems();
                int i = items.length;
                while (--i >= 0) {
                    try {
                        Integer.parseInt(items[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        items[i] = items[i].replaceFirst("LUN \\d*: (\\d*) bytes", "$1");
                    }
                    items[i] = "LUN " + i + ": " + items[i] + " bytes";
                }
                list.setItems(items);
                list.setSelection(sel);
            }
        }
        sizes.addOptionChangedListener((OptionChangedListener)new ListOptionChangedListener(sizes));
        CheckBoxOption box = new CheckBoxOption((ILabel)new StringLabel(ESRMessages.LabelLUNsMemChooseDir), "ej.pap.lun.file.use.");
        box.setInitialValue(false);
        box.setDescription((Description)new XHTMLDescription(ESRMessages.DocumentDescriptionESRPAPLUNsMemoryFolderLUN));
        box.setEnableCondition(onS3);
        BrowseOption browse = new BrowseOption((ILabel)new StringLabel(""), "ej.pap.lun.file.path.", CommonMessages.LabelBrowse, ESRMessages.LabelLUNsMemFileBrowse, null);
        browse.setInitialValue("");
        browse.setOptionValidator((OptionValidator)new FileOptionValidator(ESRMessages.LabelLUNsMemFolderValidator, false, true, true, true));
        browse.setEnableCondition((Expression)new CheckBoxSelected(box));
        PageContent[] contents = new PageContent[]{sizes, box, browse};
        LabelGroup grp = new LabelGroup(ESRMessages.GroupLUNsMemories, contents, 1);
        grp.setDescription((Description)new XHTMLDescription(ESRMessages.DocumentDescriptionESRPAPLUNsMemoryFileGroup));
        return grp;
    }

    @Override
    protected String getCategoryPageName() {
        return ESRMessages.CategoryLUNS;
    }
}

