/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.lib.osgi;

import com.is2t.microej.workbench.ext.Page;
import com.is2t.microej.workbench.ext.pages.lib.ESRMessages;
import com.is2t.microej.workbench.ext.pages.lib.osgi.OSGIMessages;
import com.is2t.microej.workbench.ext.validator.TextFieldOptionValidator;
import com.is2t.microej.workbench.std.launch.ext.BrowseOption;
import com.is2t.microej.workbench.std.launch.ext.CategoryPage;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.BooleanConstant;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;

public class OSGIPage
extends Page {
    private Group osgi;

    public OSGIPage(Page superPage) {
        super(superPage);
    }

    @Override
    protected CategoryPage buildCategoryPage() {
        this.osgi = this.newOSGIGroup();
        return new CategoryPage(ESRMessages.CategoryOSGIME, this.osgi);
    }

    @Override
    protected Expression getCategoryPageVisibilityExpression() {
        return null;
    }

    public Group newOSGIGroup() {
        PageContent[] pageContents = new PageContent[]{this.buildOSGIPropertiesGroup(), this.buildConfigurationGroup()};
        return new Group(pageContents, 1);
    }

    public Group buildOSGIPropertiesGroup() {
        CheckBoxOption enablePersistentStorageInitialization = new CheckBoxOption((ILabel)new StringLabel(OSGIMessages.LabelOSGIInitializePersistentStorage), "osgi.persistentStorage.initialize");
        enablePersistentStorageInitialization.setDescription((Description)new XHTMLDescription(OSGIMessages.DocumentDescriptionESROSGIPropertiesPersistentStorageInitializeCheck));
        enablePersistentStorageInitialization.setInitialValue(true);
        enablePersistentStorageInitialization.setEnableCondition((Expression)BooleanConstant.FALSE);
        CheckBoxOption enableLogger = new CheckBoxOption((ILabel)new StringLabel(OSGIMessages.LabelOSGIActivateLogger), "osgi.logger.activate");
        enableLogger.setDescription((Description)new XHTMLDescription(OSGIMessages.DocumentDescriptionESROSGIPropertiesLoggerActivateCheck));
        enableLogger.setInitialValue(false);
        TextFieldOption logClass = new TextFieldOption((ILabel)new StringLabel(OSGIMessages.LabelLogClass), "osgi.logger.class");
        logClass.setInitialValue("org.osgi.framework.LoggerTraceImpl");
        logClass.setEnableCondition((Expression)new CheckBoxSelected(enableLogger));
        logClass.setOptionValidator((OptionValidator)new TextFieldOptionValidator(OSGIMessages.LabelLogClass));
        logClass.setDescription((Description)new XHTMLDescription(OSGIMessages.DocumentLogClass));
        PageContent[] pageContents = new PageContent[]{enablePersistentStorageInitialization, enableLogger, logClass};
        return new LabelGroup(OSGIMessages.LabelOSGIProperties, pageContents, 1);
    }

    public Group buildConfigurationGroup() {
        CheckBoxOption enableConf = new CheckBoxOption((ILabel)new StringLabel(OSGIMessages.LabelOSGIAddFrameworkConfiguration), "osgi.framework.configuration.enable");
        enableConf.setDescription((Description)new XHTMLDescription(OSGIMessages.DocumentDescriptionESROSGIUseConfigurationFile));
        enableConf.setInitialValue(false);
        BrowseOption browseOption = new BrowseOption((ILabel)new StringLabel(OSGIMessages.LabelConfigurationFile), "osgi.framework.configuration.file", OSGIMessages.LabelBrowseConfigurationFile, OSGIMessages.LabelBrowseConfigurationFileTitle, new String[]{"*.ini", "*.xml"});
        browseOption.setInitialValue("${project_loc}/configuration/conf.ini");
        browseOption.setDescription((Description)new XHTMLDescription(OSGIMessages.DocumentDescriptionESROSGIConfigurationFile));
        browseOption.setEnableCondition((Expression)new CheckBoxSelected(enableConf));
        return new LabelGroup(OSGIMessages.LabelOSGIConfiguration, new PageContent[]{enableConf, browseOption}, 1);
    }
}

