/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.lib.bon;

import com.is2t.microej.workbench.ext.Page;
import com.is2t.microej.workbench.ext.pages.lib.ESRMessages;
import com.is2t.microej.workbench.ext.validator.IntOptionValidator;
import com.is2t.microej.workbench.ext.widget.ComboOption;
import com.is2t.microej.workbench.std.launch.ext.CategoryPage;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import org.eclipse.osgi.util.NLS;

public class PersistencePage
extends Page {
    public Group persistence;

    public PersistencePage(Page superPage) {
        super(superPage);
    }

    @Override
    protected CategoryPage buildCategoryPage() {
        this.persistence = this.buildPersistenceGroup();
        if (this.persistence != null) {
            return new CategoryPage(ESRMessages.CategoryPersistence, this.persistence);
        }
        return null;
    }

    @Override
    protected Expression getCategoryPageVisibilityExpression() {
        return null;
    }

    public Group buildPersistenceGroup() {
        return null;
    }

    public Group buildPersistenceGroup(final int maxMemory, int sectorSize, int maxSectors, int defaultNbSectors, int defaultNbBlocks) {
        OptionValidator validator;
        String propertyHeader = MainPage.getPropertyHeader();
        int defaultMemUsed = defaultNbSectors * defaultNbBlocks;
        String[] sectorsLabels = new String[maxSectors];
        String[] sectorsItems = new String[maxSectors];
        int size = sectorSize;
        int i = -1;
        while (++i < maxSectors) {
            sectorsLabels[i] = Integer.toString(size);
            sectorsItems[i] = Integer.toString(i + 1);
            size += sectorSize;
        }
        HiddenOption sectorSizeOpt = new HiddenOption("hidden", String.valueOf(propertyHeader) + "ej.bon.immutable.sector.size", Integer.toString(sectorSize));
        LabelOption labelSectorsSign = new LabelOption(" ");
        LabelOption labelBlocksSign = new LabelOption("*");
        LabelOption labelFreeMemorySign = new LabelOption("+");
        LabelOption labelMaxMemorySign = new LabelOption("=");
        LabelOption labelSectors = new LabelOption(ESRMessages.LabelImmutableBlocksSectors);
        LabelOption labelBlocks = new LabelOption(ESRMessages.LabelImmutableBlocksNumber);
        LabelOption labelFreeMemory = new LabelOption(ESRMessages.LabelImmutableBlocksFreeMemory);
        LabelOption labelMaxMemory = new LabelOption(ESRMessages.LabelImmutableBlocksMaxMemory);
        final TextFieldOption blocks = new TextFieldOption((ILabel)labelSectors, String.valueOf(propertyHeader) + "ej.bon.immutable.blocks");
        final LabelOption freeMemory = new LabelOption(Integer.toString(defaultMemUsed));
        LabelOption maxMem = new LabelOption(Integer.toString(maxMemory));
        final ComboOption sectors = new ComboOption((ILabel)labelBlocks, String.valueOf(propertyHeader) + "ej.bon.immutable.sectors", sectorsLabels, sectorsItems);
        blocks.setDescription((Description)new XHTMLDescription(ESRMessages.DocumentDescriptionESRBONPersistenceBlocksNumber));
        blocks.setInitialValue(Integer.toString(defaultNbBlocks));
        sectors.setDescription((Description)new XHTMLDescription(ESRMessages.DocumentDescriptionESRBONPersistenceBlocksSize));
        sectors.setInitialValue(defaultNbSectors - 1);
        blocks.validator = validator = new OptionValidator(){

            public String getErrorMessage(PageContent arg0) {
                int blockSize;
                String error = new IntOptionValidator(ESRMessages.LabelImmutableBlocksNumber).getErrorMessage(arg0);
                if (error != null) {
                    return error;
                }
                int nbBlocks = Integer.parseInt(blocks.getSelection());
                if (nbBlocks * (blockSize = Integer.parseInt(sectors.getSelection())) > maxMemory) {
                    return NLS.bind((String)ESRMessages.ErrorImmutableBlocks, (Object[])new Object[]{ESRMessages.LabelImmutableBlocksFreeMemory, Integer.toString(maxMemory)});
                }
                return null;
            }
        };
        OptionChangedListener listener = new OptionChangedListener(){

            public void changed() {
                try {
                    int nbBlocks = Integer.parseInt(blocks.getSelection());
                    int sectorSize = Integer.parseInt(sectors.getSelection());
                    int mem = maxMemory - sectorSize * nbBlocks;
                    freeMemory.labelWidget.setText(Integer.toString(mem));
                }
                catch (Exception exception) {}
            }
        };
        blocks.addOptionChangedListener(listener);
        sectors.addOptionChangedListener(listener);
        LabelGroup grp = new LabelGroup(ESRMessages.GroupImmutableBlocks, new PageContent[]{labelSectorsSign, labelSectors, sectors, labelBlocksSign, labelBlocks, blocks, labelFreeMemorySign, labelFreeMemory, freeMemory, labelMaxMemorySign, labelMaxMemory, maxMem, sectorSizeOpt}, 3);
        return grp;
    }
}

