/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.lib;

import com.is2t.microej.workbench.ext.Page;
import com.is2t.microej.workbench.ext.pages.lib.JSREMessages;
import com.is2t.microej.workbench.ext.validator.IntIntervalOptionValidator;
import com.is2t.microej.workbench.ext.validator.IntOptionValidator;
import com.is2t.microej.workbench.std.launch.ext.CategoryPage;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Vector;

public class JavaxUSBPage
extends Page {
    protected String propertyHeader = MainPage.getPropertyHeader();
    protected Hashtable defaultValues = new Hashtable();

    public JavaxUSBPage(Page superPage) {
        super(superPage);
        this.initDefaultValues(this.defaultValues);
    }

    protected void initDefaultValues(Hashtable defaultValues) {
        defaultValues.put("javax.usb.topology.period", "1000");
        defaultValues.put("javax.usb.fs.root.sim", "/dev/bus/usb");
        defaultValues.put("javax.usb.fs.root.emb", "/dev/bus/usb");
        defaultValues.put("javax.usb.serial.file.sim", "/proc/tty/driver/usbserial");
        defaultValues.put("javax.usb.serial.file.emb", "/proc/tty/driver/usbserial");
        defaultValues.put("javax.usb.serial.tty.path.sim", "/dev/ttyUSB");
        defaultValues.put("javax.usb.serial.tty.path.emb", "/dev/ttyUSB");
    }

    @Override
    protected CategoryPage buildCategoryPage() {
        Group topology = this.newTopologyGroup();
        Group usbFS = this.newUsbFileSystemGroup();
        Group comm = this.newCommunicationGroup();
        return new CategoryPage(JSREMessages.CategoryJavaxUsb, new Group(new PageContent[]{topology, usbFS, comm}, 1));
    }

    @Override
    protected Expression getCategoryPageVisibilityExpression() {
        return null;
    }

    protected Group newTopologyGroup() {
        CheckBoxOption activate = new CheckBoxOption((ILabel)new StringLabel(JSREMessages.ActivateTopology), "javax.usb.topology");
        activate.setInitialValue(true);
        activate.setDescription((Description)new XHTMLDescription(JSREMessages.ActivateTopologyDescription));
        TextFieldOption period = new TextFieldOption((ILabel)new StringLabel(JSREMessages.TopologyPeriod), "javax.usb.topology.period");
        period.setInitialValue("1000");
        period.setOptionValidator((OptionValidator)new IntOptionValidator("javax.usb.topology.period", false));
        period.setEnableCondition((Expression)new CheckBoxSelected(activate));
        period.setDescription((Description)new XHTMLDescription(JSREMessages.TopologyPeriodDescription));
        LabelGroup group = new LabelGroup(JSREMessages.LabelTopology, new PageContent[]{activate, period}, 2);
        group.setDescription((Description)new XHTMLDescription(JSREMessages.TopologyGroupDescription));
        return group;
    }

    protected Group newUsbFileSystemGroup() {
        LabelOption empty = new LabelOption("");
        LabelOption embLabel = new LabelOption(JSREMessages.Embedded);
        LabelOption simLabel = new LabelOption(JSREMessages.Simulator);
        PageContent[] coreContents = this.usbFileSystemContents();
        PageContent[] allContents = new PageContent[coreContents.length + 3];
        allContents[0] = empty;
        allContents[1] = embLabel;
        allContents[2] = simLabel;
        System.arraycopy(coreContents, 0, allContents, 3, coreContents.length);
        LabelGroup fsGroup = new LabelGroup(JSREMessages.LabelFileSystem, allContents, 3);
        fsGroup.setDescription((Description)new XHTMLDescription(JSREMessages.FileSystemGroupDescription));
        return fsGroup;
    }

    protected PageContent[] usbFileSystemContents() {
        Vector list = new Vector();
        this.addUsbRootFileSystem(list);
        this.addUsbSerialFileSystem(list);
        return ((AbstractCollection)list).toArray(new PageContent[0]);
    }

    protected void addUsbRootFileSystem(AbstractList contents) {
        contents.add(new LabelOption(JSREMessages.UsbFSRoot));
        TextFieldOption usbFsEmb = new TextFieldOption((ILabel)new StringLabel(""), String.valueOf(this.propertyHeader) + "javax.usb.fs.root.emb");
        usbFsEmb.setInitialValue((String)this.defaultValues.get("javax.usb.fs.root.emb"));
        contents.add(usbFsEmb);
        TextFieldOption usbFsSim = new TextFieldOption((ILabel)new StringLabel(""), "javax.usb.fs.root.sim");
        usbFsSim.setInitialValue((String)this.defaultValues.get("javax.usb.fs.root.sim"));
        contents.add(usbFsSim);
    }

    protected void addUsbSerialFileSystem(AbstractList contents) {
        contents.add(new LabelOption(JSREMessages.UsbSerialFile));
        TextFieldOption usbSerialEmb = new TextFieldOption((ILabel)new StringLabel(""), String.valueOf(this.propertyHeader) + "javax.usb.serial.file.emb");
        usbSerialEmb.setInitialValue((String)this.defaultValues.get("javax.usb.serial.file.emb"));
        contents.add(usbSerialEmb);
        TextFieldOption usbSerialSim = new TextFieldOption((ILabel)new StringLabel(""), "javax.usb.serial.file.sim");
        usbSerialSim.setInitialValue((String)this.defaultValues.get("javax.usb.serial.file.sim"));
        contents.add(usbSerialSim);
        contents.add(new LabelOption(JSREMessages.UsbSerialTTY));
        TextFieldOption usbTtyEmb = new TextFieldOption((ILabel)new StringLabel(""), String.valueOf(this.propertyHeader) + "javax.usb.serial.tty.path.emb");
        usbTtyEmb.setInitialValue((String)this.defaultValues.get("javax.usb.serial.tty.path.emb"));
        contents.add(usbTtyEmb);
        TextFieldOption usbTtySim = new TextFieldOption((ILabel)new StringLabel(""), "javax.usb.serial.tty.path.sim");
        usbTtySim.setInitialValue((String)this.defaultValues.get("javax.usb.serial.tty.path.sim"));
        contents.add(usbTtySim);
    }

    protected Group newCommunicationGroup() {
        TextFieldOption maxRequest = new TextFieldOption((ILabel)new StringLabel(JSREMessages.maxPendingRequest), "javax.usb.maxPendingRequest");
        maxRequest.setInitialValue("10");
        maxRequest.setOptionValidator((OptionValidator)new IntIntervalOptionValidator(JSREMessages.maxPendingRequest, 0, true));
        maxRequest.setDescription((Description)new XHTMLDescription(JSREMessages.maxPendingRequestDescription));
        LabelGroup group = new LabelGroup(JSREMessages.UsbCommunicationGroup, new PageContent[]{maxRequest}, 1);
        group.setDescription((Description)new XHTMLDescription(JSREMessages.UsbCommunicationDescription));
        return group;
    }
}

