/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group;

import com.is2t.microej.workbench.ext.pages.emb.MemPage;
import com.is2t.microej.workbench.ext.pages.emb.memory.Memory;
import com.is2t.microej.workbench.ext.pages.emb.memory.MemoryMessages;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroup;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroupConstants;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryListener;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryValidator;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeMemory;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.ThreadsNumberI;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.ext.validator.IntIntervalOptionValidator;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import java.util.ArrayList;

public class StaticThread
extends MemoryGroup
implements MemoryGroupConstants,
ThreadsNumberI {
    public static final int NB_THREADS = 0;
    public static final int THREAD_MEMORY = 1;
    public static final int THREAD_SIZE = 2;
    public static final int THREAD_MIN_SIZE = 3;
    public static final int THREAD_INV_SIZE = 4;
    public static final int DEFAULT_THREAD_MIN_SIZE = 200;
    public static final String PROPERTY_HEADER = "core.memory.javastack";
    public static final String PROPERTY_NBTHREADS = "core.memory.threads";
    public final RuntimeMemory[] memories;
    public final int nbThreads;
    public final int defaultMemoryIndex;
    public final int defaultSize;
    public final int invariantSizePerThread;
    public TextFieldOption nb;
    private RuntimeChunk stacks;
    private int minJavaStackSize;

    public static StaticThread getGroup(MemPage page) {
        if (page.getMemoryValue(7, 0) != -1L) {
            return new StaticThread(page);
        }
        return null;
    }

    private StaticThread(MemPage mem) {
        this.nbThreads = (int)mem.getMemoryValue(7, 0);
        this.memories = mem.getMemories(7, 1);
        this.defaultMemoryIndex = (int)mem.getMemoryValue(7, 1);
        this.defaultSize = (int)mem.getMemoryValue(7, 2);
        this.invariantSizePerThread = (int)mem.getMemoryValue(7, 4);
        this.minJavaStackSize = (int)mem.getMemoryValue(7, 3);
        this.nb = new TextFieldOption((ILabel)new StringLabel(""), PROPERTY_NBTHREADS);
    }

    @Override
    public void updateSize() {
        this.stacks.updateSize();
    }

    @Override
    public Group getGroup(final MemoryListener listener, MemoryValidator validator) {
        Memory[] memories = this.memories;
        this.nb.setInitialValue(Integer.toString(this.nbThreads));
        this.nb.setOptionValidator((OptionValidator)new IntIntervalOptionValidator(MemoryMessages.ThreadLabelNumberOfThreads, 1, true));
        final RuntimeChunk stacks = this.stacks = new RuntimeChunk(MemoryMessages.ThreadLabelJavaStackSize, memories, this.defaultMemoryIndex, this.defaultSize, PROPERTY_HEADER);
        stacks.setMinSize(this.minJavaStackSize);
        stacks.finalize(listener, validator);
        stacks.setElementSize(this.nbThreads);
        stacks.setInvariantIncrement(this.nbThreads * this.invariantSizePerThread);
        ArrayList<Object> contentsVect = new ArrayList<Object>();
        int nbColumns = stacks.hasConcreteMemoryOption() ? 3 : 2;
        contentsVect.add(new LabelOption(MemoryMessages.ThreadLabelNumberOfThreads));
        if (nbColumns == 3) {
            contentsVect.add(new LabelOption(""));
        }
        contentsVect.add(this.nb);
        contentsVect.add(stacks.label);
        contentsVect.add(stacks.memoriesOption);
        contentsVect.add(stacks.memorySize);
        this.nb.addOptionChangedListener(new OptionChangedListener(){

            public void changed() {
                try {
                    int n = Tools.parseUInt(StaticThread.this.nb.getSelection());
                    stacks.setElementSize(n);
                    stacks.setInvariantIncrement(n * StaticThread.this.invariantSizePerThread);
                    listener.changed();
                }
                catch (Exception exception) {}
            }
        });
        LabelGroup grp = new LabelGroup(MemoryMessages.ThreadLabelThreads, contentsVect.toArray(new PageContent[contentsVect.size()]), nbColumns);
        return grp;
    }

    @Override
    public long getNbThreads() {
        try {
            return Tools.parseLong(this.nb.text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public void setMinJavaStackSize(int min) {
        if (min > this.minJavaStackSize) {
            this.minJavaStackSize = min;
        }
    }
}

