/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group;

import com.is2t.microej.workbench.ext.pages.emb.MemPage;
import com.is2t.microej.workbench.ext.pages.emb.memory.Memory;
import com.is2t.microej.workbench.ext.pages.emb.memory.MemoryMessages;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroupConstants;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunksGroup;

public class MicroUI
implements MemoryGroupConstants {
    public static final int NB_IMAGES = 0;
    public static final int NB_MINIMAGES = 1;
    public static final int IMAGE_SIZE = 2;
    public static final int IMAGE_MEMORY = 3;
    public static final int EXTERNAL_ALLOCATOR_SIZE = 4;
    public static final int EXTERNAL_ALLOCATOR_INVARIANT_SIZE = 5;
    public static final int EXTERNAL_ALLOCATOR_MEMORY = 6;
    public static final int LCD_BUFFER_SIZE = 7;
    public static final int LCD_BUFFER_MEMORY = 8;
    public static final int NB_FIMAGES = 9;
    public static final int NB_MINFIMAGES = 10;
    public static final int FIMAGE_SIZE = 11;
    public static final int FIMAGE_MEMORY = 12;
    public static final int NB_FONTS = 13;
    public static final int NB_MINFONTS = 14;
    public static final int FONT_SIZE = 15;
    public static final int FONT_MEMORY = 16;
    public static final int NB_EVENTS = 17;
    public static final int NB_MINEVENTS = 18;
    public static final int EVENT_SIZE = 19;
    public static final int EVENT_MEMORY = 20;
    public static final int DEFAULT_EXTERNAL_ALLOCATOR_INVARIANT_SIZE = 2580;
    public static final String NBIMAGES_PROPERTY_HEADER = "mui.images";
    public static final String NBFIMAGES_PROPERTY_HEADER = "mui.flying.images";
    public static final String NBFONTS_PROPERTY_HEADER = "mui.fonts";
    public static final String NBEVENTS_PROPERTY_HEADER = "mui.inputs.buffer";
    public static final String ALLOCATOR_PROPERTY_HEADER = "mui.external.allocator";
    public static final String LCDBUFFER_PROPERTY_HEADER = "core.memory.lcdbuffer";

    public static RuntimeChunksGroup getGroup(MemPage page) {
        long lcdBufferSize;
        long externalAllocatorSize;
        int nbEvents;
        int nbFonts;
        int nbFImages;
        int nbChunks = 0 + page.useChunk(2, 0) + page.useChunk(2, 9) + page.useChunk(2, 13) + page.useChunk(2, 17) + page.useChunk(2, 4) + page.useChunk(2, 7);
        if (nbChunks == 0) {
            return null;
        }
        RuntimeChunk[] chunks = new RuntimeChunk[nbChunks];
        int ci = 0;
        int nbImages = (int)page.getMemoryValue(2, 0);
        if (nbImages != -1) {
            Memory[] mems = page.getMemories(2, 3, 0);
            int index = (int)page.getMemoryValue(2, 3, 0);
            long size = page.getMemoryValue(2, 2, 0);
            RuntimeChunk images = new RuntimeChunk(MemoryMessages.MUILabelNumberOfImages, mems, index, nbImages, NBIMAGES_PROPERTY_HEADER);
            images.setElementSize(size);
            images.setMinSize((int)page.getMemoryValue(2, 1));
            images.setDescription(MemoryMessages.MicroUIDescImages);
            chunks[ci++] = images;
        }
        if ((nbFImages = (int)page.getMemoryValue(2, 9)) != -1) {
            Memory[] mems = page.getMemories(2, 12, 0);
            int index = (int)page.getMemoryValue(2, 12, 0);
            long size = page.getMemoryValue(2, 11, 0);
            RuntimeChunk images = new RuntimeChunk(MemoryMessages.MUILabelNumberOfFlyingImages, mems, index, nbFImages, NBFIMAGES_PROPERTY_HEADER);
            images.setElementSize(size);
            images.setMinSize((int)page.getMemoryValue(2, 10));
            images.setDescription(MemoryMessages.MicroUIDescFImages);
            chunks[ci++] = images;
        }
        if ((nbFonts = (int)page.getMemoryValue(2, 13)) != -1) {
            Memory[] mems = page.getMemories(2, 16, 0);
            int index = (int)page.getMemoryValue(2, 16, 0);
            long size = page.getMemoryValue(2, 15, 0);
            RuntimeChunk fonts = new RuntimeChunk(MemoryMessages.MUILabelNumberOfFonts, mems, index, nbFonts, NBFONTS_PROPERTY_HEADER);
            fonts.setElementSize(size);
            fonts.setMinSize((int)page.getMemoryValue(2, 14));
            fonts.setDescription(MemoryMessages.MicroUIDescFonts);
            chunks[ci++] = fonts;
        }
        if ((nbEvents = (int)page.getMemoryValue(2, 17)) != -1) {
            Memory[] mems = page.getMemories(2, 20, 0);
            int index = (int)page.getMemoryValue(2, 20, 0);
            long size = page.getMemoryValue(2, 19, 0);
            RuntimeChunk events = new RuntimeChunk(MemoryMessages.MUILabelNumberOfEvents, mems, index, nbEvents, NBEVENTS_PROPERTY_HEADER);
            events.setElementSize(size);
            events.setMinSize((int)page.getMemoryValue(2, 18));
            events.setDescription(MemoryMessages.MicroUIDescEvents);
            chunks[ci++] = events;
        }
        if ((externalAllocatorSize = page.getMemoryValue(2, 4)) != -1L) {
            Memory[] mems = page.getMemories(2, 6, 0);
            int index = (int)page.getMemoryValue(2, 6, 0);
            long size = page.getMemoryValue(2, 5, 0);
            RuntimeChunk allocator = new RuntimeChunk(MemoryMessages.MUILabelPNGBufferSize, mems, index, externalAllocatorSize, ALLOCATOR_PROPERTY_HEADER);
            allocator.addInvariantIncrement(size);
            allocator.setDescription(MemoryMessages.MicroUIDescPNGBuffer);
            chunks[ci++] = allocator;
        }
        if ((lcdBufferSize = page.getMemoryValue(2, 7)) != -1L) {
            Memory[] mems = page.getMemories(2, 8, 0);
            int index = (int)page.getMemoryValue(2, 8, 0);
            RuntimeChunk lcd = new RuntimeChunk(MemoryMessages.MUILabelLCDBufferSize, mems, index, lcdBufferSize, LCDBUFFER_PROPERTY_HEADER);
            lcd.setDescription(MemoryMessages.MicroUIDescLCDBuffer);
            lcd.enable(false);
            chunks[ci++] = lcd;
        }
        RuntimeChunksGroup mui = new RuntimeChunksGroup(MemoryMessages.MUILabelMicroUI, chunks);
        return mui;
    }
}

