/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group;

import com.is2t.microej.workbench.ext.pages.emb.MemPage;
import com.is2t.microej.workbench.ext.pages.emb.memory.Memory;
import com.is2t.microej.workbench.ext.pages.emb.memory.MemoryMessages;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroupConstants;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunksGroup;

public class IceOS
implements MemoryGroupConstants {
    public static final int NB_THREADS = 0;
    public static final int NB_ALARMS = 1;
    public static final int NB_MONITORS = 2;
    public static final int THREAD_SIZE = 3;
    public static final int ALARM_SIZE = 4;
    public static final int MONITOR_SIZE = 5;
    public static final int THREAD_MEMORY = 6;
    public static final int ALARM_MEMORY = 7;
    public static final int MONITOR_MEMORY = 8;
    public static final int NB_MINTHREADS = 9;
    public static final int NB_MINALARMS = 10;
    public static final int NB_MINMONITORS = 11;
    public static final String NBTHREADS_PROPERTY_HEADER = "nb_native_threads";
    public static final String NBALARMS_PROPERTY_HEADER = "nb_native_alarms";
    public static final String NBMONITORS_PROPERTY_HEADER = "nb_native_monitors";

    public static RuntimeChunksGroup getGroup(MemPage page) {
        int nbAlarms;
        int nbChunks = 0 + page.useChunk(10, 0) + page.useChunk(10, 1) + page.useChunk(10, 2);
        if (nbChunks == 0) {
            return null;
        }
        RuntimeChunk[] chunks = new RuntimeChunk[nbChunks];
        int ci = 0;
        int nbThreads = (int)page.getMemoryValue(10, 0);
        if (nbThreads != -1) {
            Memory[] mems = page.getMemories(10, 6, 0);
            int index = (int)page.getMemoryValue(10, 6, 0);
            long size = page.getMemoryValue(10, 3, 0);
            RuntimeChunk threads = new RuntimeChunk(MemoryMessages.ICEOSLabelNumberOfThreads, mems, index, nbThreads, NBTHREADS_PROPERTY_HEADER);
            threads.setElementSize(size);
            threads.setMinSize((int)page.getMemoryValue(10, 9));
            threads.setDescription(MemoryMessages.ICEOSDescThreads);
            chunks[ci++] = threads;
        }
        if ((nbAlarms = (int)page.getMemoryValue(10, 1)) != -1) {
            Memory[] mems = page.getMemories(10, 7, 0);
            int index = (int)page.getMemoryValue(10, 7, 0);
            long size = page.getMemoryValue(10, 4, 0);
            RuntimeChunk alarms = new RuntimeChunk(MemoryMessages.ICEOSLabelNumberOfAlarms, mems, index, nbAlarms, NBALARMS_PROPERTY_HEADER);
            alarms.setElementSize(size);
            alarms.setMinSize((int)page.getMemoryValue(10, 10));
            alarms.setDescription(MemoryMessages.ICEOSDescAlarms);
            chunks[ci++] = alarms;
        }
        int nbMonitors = (int)page.getMemoryValue(10, 2);
        if (nbThreads != -1) {
            Memory[] mems = page.getMemories(10, 8, 0);
            int index = (int)page.getMemoryValue(10, 8, 0);
            long size = page.getMemoryValue(10, 5, 0);
            RuntimeChunk monitors = new RuntimeChunk(MemoryMessages.ICEOSLabelNumberOfMonitors, mems, index, nbMonitors, NBMONITORS_PROPERTY_HEADER);
            monitors.setElementSize(size);
            monitors.setMinSize((int)page.getMemoryValue(10, 11));
            monitors.setDescription(MemoryMessages.ICEOSDescMonitors);
            chunks[ci++] = monitors;
        }
        RuntimeChunksGroup iceos = new RuntimeChunksGroup(MemoryMessages.ICEOSLabelIceOS, chunks);
        return iceos;
    }
}

