/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group;

import com.is2t.microej.workbench.ext.pages.emb.EmbMessages;
import com.is2t.microej.workbench.ext.pages.emb.MemPage;
import com.is2t.microej.workbench.ext.pages.emb.memory.Chunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.Memory;
import com.is2t.microej.workbench.ext.pages.emb.memory.MemoryMessages;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroupConstants;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunksGroup;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeMemory;
import com.is2t.microej.workbench.ext.widget.ComboOption;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import org.eclipse.osgi.util.NLS;

public class Heap
implements MemoryGroupConstants {
    public static final int NBHEAPS = 0;
    public static final int HEAP_SIZE = 1;
    public static final int HEAP_MINSIZE = 2;
    public static final int IMM_SIZE = 3;
    public static final int IMM_MINSIZE = 4;
    public static final int HEAP_MEMORY = 5;
    public static final int IMM_MEMORY = 6;
    public static final String PROPERTY_HEADER = "core.memory.javaheap";
    public static final String IMM_PROPERTY_HEADER = "core.memory.immortal";
    public static final String SUM_PROPERTY_HEADER = "core.memory.javaheapsum.size";

    public static RuntimeChunksGroup getGroup(MemPage page) {
        int nbHeaps;
        int n = (int)page.getMemoryValue(1, 0);
        int l = nbHeaps = n == -1 ? 0 : n;
        if ((l += page.getMemoryValue(1, 3) != -1L ? 1 : 0) == 0) {
            return null;
        }
        final RuntimeChunk[] chunks = new RuntimeChunk[l];
        long defaultSum = 0L;
        if (nbHeaps > 1) {
            int i = -1;
            while (++i < nbHeaps) {
                Memory[] mems = page.getMemories(1, 5, i);
                int index = (int)page.getMemoryValue(1, 5, i);
                long size = page.getMemoryValue(1, 1, i);
                defaultSum += size;
                int ml = mems.length;
                Memory[] memoryArray = mems;
                mems = new RuntimeMemory[ml + 1];
                System.arraycopy(memoryArray, 0, mems, 1, ml);
                mems[0] = Chunk.getMemoryNotUsed();
                RuntimeChunk chunk = new RuntimeChunk(NLS.bind((String)MemoryMessages.HeapLabelJavaHeap, (Object[])new String[]{Integer.toString(i)}), mems, index, size, PROPERTY_HEADER + i);
                chunk.setMinSize(page.getMemoryValue(1, 2, i));
                chunk.setDescription(NLS.bind((String)MemoryMessages.HeapDescHeap, (Object[])new String[]{Integer.toString(i)}));
                ComboOption combo = chunk.getMemoriesOptionAsCombo();
                combo.setOptionValidator(new OptionValidator(){

                    public String getErrorMessage(PageContent arg0) {
                        int nouse = 0;
                        int i = nbHeaps;
                        while (--i >= 0) {
                            nouse += chunks[i].getMemoriesOptionAsCombo().combo.getSelectionIndex() == 0 ? 1 : 0;
                        }
                        if (nouse == nbHeaps) {
                            return EmbMessages.ErrorNoJavaHeap;
                        }
                        return null;
                    }
                });
                chunks[i] = chunk;
            }
        } else if (nbHeaps == 1) {
            Memory[] mems = page.getMemories(1, 5, 0);
            int index = (int)page.getMemoryValue(1, 5, 0);
            long size = page.getMemoryValue(1, 1, 0);
            RuntimeChunk chunk = new RuntimeChunk(NLS.bind((String)MemoryMessages.HeapLabelJavaHeap, (Object[])new String[]{""}), mems, index, size, PROPERTY_HEADER);
            chunk.setMinSize(page.getMemoryValue(1, 2, 0));
            chunk.setDescription(NLS.bind((String)MemoryMessages.HeapDescHeap, (Object[])new String[]{""}));
            chunks[0] = chunk;
        }
        int index = nbHeaps;
        long size = page.getMemoryValue(1, 3, 0);
        if (size != -1L) {
            Memory[] mems = page.getMemories(1, 6, 0);
            int i = (int)page.getMemoryValue(1, 6, 0);
            RuntimeChunk chunk = new RuntimeChunk(MemoryMessages.HeapLabelImmortalHeap, mems, i, size, IMM_PROPERTY_HEADER);
            chunk.setMinSize(page.getMemoryValue(1, 4));
            chunk.setDescription(MemoryMessages.HeapDescImmortal);
            chunks[index] = chunk;
            ++index;
        }
        RuntimeChunksGroup heaps = new RuntimeChunksGroup(MemoryMessages.HeapLabelHeaps, chunks);
        heaps.setHiddenOptions(new PageContent[]{Heap.getHeapSumOption(chunks, nbHeaps, (int)defaultSum)});
        return heaps;
    }

    private static HiddenOption getHeapSumOption(final RuntimeChunk[] chunks, final int nbHeaps, int defaultSum) {
        final HiddenOption heapSum = new HiddenOption(null, SUM_PROPERTY_HEADER, "" + defaultSum);
        OptionChangedListener heapSizeSum = new OptionChangedListener(){

            public void changed() {
                try {
                    long heapSize = 0L;
                    int i = nbHeaps;
                    while (--i >= 0) {
                        heapSize += chunks[i].getSize();
                    }
                    heapSum.outputValue = Long.toString(heapSize);
                }
                catch (Exception exception) {}
            }
        };
        int i = nbHeaps;
        while (--i >= 0) {
            chunks[i].memoriesOption.addOptionChangedListener(heapSizeSum);
            chunks[i].memorySize.addOptionChangedListener(heapSizeSum);
        }
        return heapSum;
    }
}

