/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group;

import com.is2t.microej.workbench.ext.pages.emb.MemPage;
import com.is2t.microej.workbench.ext.pages.emb.memory.Chunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.Memory;
import com.is2t.microej.workbench.ext.pages.emb.memory.MemoryMessages;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroupConstants;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.ResourcesPoolWithStackGroup;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunksGroup;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.ThreadsNumberI;
import java.util.ArrayList;

public class ECOM
implements MemoryGroupConstants {
    public static final int NB_COMM = 0;
    public static final int NB_COMM_MAX = 1;
    public static final int COMM_SIZE = 2;
    public static final int COMM_INV_SIZE = 3;
    public static final int COMM_MEMORY = 4;
    public static final int NB_SOCKET = 5;
    public static final int SOCKET_STACK_SIZE = 6;
    public static final int SOCKET_INTERNAL_SIZE = 7;
    public static final int SOCKET_MEMORY = 8;
    public static final int SOCKET_INV_STACK_SIZE = 9;
    public static final int SOCKET_INV_INTERNAL_SIZE = 10;
    public static final int NB_SERVER_SOCKET = 11;
    public static final int SERVER_SOCKET_STACK_SIZE = 12;
    public static final int SERVER_SOCKET_INTERNAL_SIZE = 13;
    public static final int SERVER_SOCKET_MEMORY = 14;
    public static final int SERVER_SOCKET_INV_STACK_SIZE = 15;
    public static final int SERVER_SOCKET_INV_INTERNAL_SIZE = 16;
    public static final String NBCOMM_PROPERTY_HEADER = "ecom.comm.number";
    public static final String NBSOCKET_PROPERTY_HEADER = "ecom.socket.number";
    public static final String NBSERVERSOCKET_PROPERTY_HEADER = "ecom.serversocket.number";

    public static RuntimeChunksGroup getGroup(MemPage page, ThreadsNumberI threadsGroup, Chunk systemMemoryChunk) {
        long nbServerSocket;
        long nbSocket;
        ArrayList<RuntimeChunk> chunks = new ArrayList<RuntimeChunk>();
        int nbComm = (int)page.getMemoryValue(3, 0);
        if (nbComm != -1) {
            Memory[] mems = page.getMemories(3, 4, 0);
            int index = (int)page.getMemoryValue(3, 4, 0);
            long size = page.getMemoryValue(3, 2, 0);
            long inv = page.getMemoryValue(3, 3, 0);
            int max = (int)page.getMemoryValue(3, 1, 0);
            RuntimeChunk comm = new RuntimeChunk(MemoryMessages.ECOMLabelNumberOfCommConnection, mems, index, nbComm, NBCOMM_PROPERTY_HEADER);
            comm.setElementSize(size);
            comm.setInvariantIncrement(inv);
            comm.setDescription(MemoryMessages.ECOMDescComm);
            comm.setMinSize(0L);
            comm.setMaxSize(max);
            chunks.add(comm);
        }
        if ((nbSocket = page.getMemoryValue(3, 5)) != -1L) {
            Memory[] mems = page.getMemories(3, 8, 0);
            int index = (int)page.getMemoryValue(3, 8, 0);
            long stackSize = page.getMemoryValue(3, 6, 0);
            long internalSize = page.getMemoryValue(3, 7, 0);
            long stackSizeInvariant = page.getMemoryValue(3, 9, 0);
            long internalSizeInvariant = page.getMemoryValue(3, 10, 0);
            ResourcesPoolWithStackGroup chunk = new ResourcesPoolWithStackGroup(MemoryMessages.ECOMLabelNumberOfSocketConnection, mems, index, nbSocket, internalSize, internalSizeInvariant, NBSOCKET_PROPERTY_HEADER, threadsGroup, systemMemoryChunk);
            chunk.setElementSize(stackSize);
            chunk.setInvariantIncrement(stackSizeInvariant);
            chunk.setMinSize(0L);
            chunks.add(chunk);
        }
        if ((nbServerSocket = page.getMemoryValue(3, 11)) != -1L) {
            Memory[] mems = page.getMemories(3, 14, 0);
            int index = (int)page.getMemoryValue(3, 14, 0);
            long stackSize = page.getMemoryValue(3, 12, 0);
            long internalSize = page.getMemoryValue(3, 13, 0);
            long stackSizeInvariant = page.getMemoryValue(3, 15, 0);
            long internalSizeInvariant = page.getMemoryValue(3, 16, 0);
            ResourcesPoolWithStackGroup chunk = new ResourcesPoolWithStackGroup(MemoryMessages.ECOMLabelNumberOfServerSocketConnection, mems, index, nbServerSocket, internalSize, internalSizeInvariant, NBSERVERSOCKET_PROPERTY_HEADER, threadsGroup, systemMemoryChunk);
            chunk.setElementSize(stackSize);
            chunk.setInvariantIncrement(stackSizeInvariant);
            chunk.setMinSize(0L);
            chunks.add(chunk);
        }
        if (chunks.isEmpty()) {
            return null;
        }
        RuntimeChunksGroup ecom = new RuntimeChunksGroup(MemoryMessages.ECOMLabelECOM, chunks.toArray(new RuntimeChunk[0]));
        return ecom;
    }
}

