/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime;

import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroup;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryListener;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryValidator;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunk;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;

public class RuntimeChunksGroup
extends MemoryGroup {
    public static final int NB_ELEMENTS_PER_CHUNKS = 3;
    public final String label;
    public final RuntimeChunk[] chunks;
    private Group group;
    private Expression enableCondition;
    private PageContent[] hiddenOptions;

    public RuntimeChunksGroup(String label, RuntimeChunk[] chunks) {
        this.label = label;
        this.chunks = chunks;
    }

    @Override
    public void updateSize() {
        if (this.group.isEnabled()) {
            RuntimeChunk[] chunks = this.chunks;
            int i = chunks.length;
            while (--i >= 0) {
                chunks[i].updateSize();
            }
        }
    }

    @Override
    public Group getGroup(MemoryListener listener, MemoryValidator validator) {
        RuntimeChunk[] chunks = this.chunks;
        int l = chunks.length;
        int hl = this.hiddenOptions == null ? 0 : this.hiddenOptions.length;
        PageContent[] contents = new PageContent[3 * l + hl];
        int nbColumns = 0;
        int i = -1;
        while (++i < l) {
            int nbChunkColumns;
            RuntimeChunk chunk = chunks[i];
            int j = i * 3;
            chunk.finalize(listener, validator);
            contents[j] = chunk.label;
            contents[j + 1] = chunk.memoriesOption;
            contents[j + 2] = chunk.memorySize;
            int n = nbChunkColumns = chunk.hasConcreteMemoryOption() ? 3 : 2;
            if (nbColumns >= nbChunkColumns) continue;
            nbColumns = nbChunkColumns;
        }
        if (hl > 0) {
            System.arraycopy(this.hiddenOptions, 0, contents, 3 * l, hl);
        }
        LabelGroup grp = new LabelGroup(this.label, contents, nbColumns);
        grp.setEnableCondition(this.enableCondition);
        this.group = grp;
        return grp;
    }

    public void setEnableCondition(Expression enableCondition) {
        this.enableCondition = enableCondition;
    }

    public void setHiddenOptions(PageContent[] hiddenOptions) {
        this.hiddenOptions = hiddenOptions;
    }
}

