/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime;

import com.is2t.microej.workbench.ext.pages.emb.memory.Chunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.Memory;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryListener;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeMemory;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.ext.validator.IntIntervalOptionValidator;
import com.is2t.microej.workbench.ext.validator.MultiOptionValidators;
import com.is2t.microej.workbench.std.launch.ext.ComboOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.BooleanConstant;
import com.is2t.microej.workbench.std.launch.ext.expr.ComboMatchingIndexes;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import com.is2t.microej.workbench.std.launch.ext.expr.UnaryExpression;

public class RuntimeChunk
extends Chunk {
    public static final String PROPERTY_SIZE = ".size";
    public final TextFieldOption memorySize;
    private long elementSize = 1L;
    private long invariantIncrement = 0L;
    private long minSize = 0L;
    private long maxSize = Long.MIN_VALUE;

    public RuntimeChunk(String label, Memory[] memories, int defaultMemIndex, long defaultSize, String propertyHeader) {
        super(label, memories, defaultMemIndex, propertyHeader);
        this.memorySize = this.createMemorySizeOption(memories, defaultMemIndex, defaultSize, propertyHeader);
    }

    public void finalize(MemoryListener listener, OptionValidator validator) {
        super.finalize(listener);
        TextFieldOption mem = this.memorySize;
        if (listener != null) {
            mem.addOptionChangedListener((OptionChangedListener)listener);
        }
        String label = mem.label.getText();
        IntIntervalOptionValidator minmax = this.maxSize != Long.MIN_VALUE ? new IntIntervalOptionValidator(label, (int)this.minSize, (int)this.maxSize) : new IntIntervalOptionValidator(label, (int)this.minSize, true);
        mem.setOptionValidator(MultiOptionValidators.getOptionValidator(validator, minmax));
    }

    public void enable(boolean enable) {
        TextFieldOption text = this.memorySize;
        if (enable) {
            if (this.canDisable()) {
                if (this.memories.length > 1) {
                    text.setEnableCondition((Expression)new UnaryExpression(1, (Expression)new ComboMatchingIndexes((ComboOption)this.getMemoriesOptionAsCombo(), new int[1])));
                }
            } else {
                text.setEnableCondition((Expression)BooleanConstant.TRUE);
            }
        } else {
            text.setEnableCondition((Expression)BooleanConstant.FALSE);
        }
    }

    public void setMinSize(long min) {
        if (min >= 0L) {
            this.minSize = min;
        }
    }

    public void setMaxSize(long max) {
        this.maxSize = max;
    }

    public void setElementSize(long size) {
        this.elementSize = size;
    }

    public void addInvariantIncrement(long inc) {
        this.invariantIncrement += inc;
    }

    public void setInvariantIncrement(long inc) {
        this.invariantIncrement = inc;
    }

    public void setDescription(String desc) {
        this.memorySize.setDescription((Description)new XHTMLDescription(desc));
    }

    public boolean isUsed() {
        if (this.memories.length > 1) {
            int sel = this.getMemoriesOptionAsCombo().combo.getSelectionIndex();
            return sel != -1 && (!this.canDisable() || sel != 0);
        }
        return true;
    }

    public long getSize() {
        if (!this.isUsed()) {
            return 0L;
        }
        try {
            return this.realMemorySize() * this.elementSize + this.invariantIncrement;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public void updateSize() {
        if (!this.isUsed()) {
            return;
        }
        RuntimeMemory memory = this.memories.length > 1 ? (RuntimeMemory)this.memories[this.getMemoriesOptionAsCombo().combo.getSelectionIndex()] : (RuntimeMemory)this.memories[0];
        memory.add(this.getSize());
    }

    protected long realMemorySize() throws NumberFormatException {
        return Tools.parseLong(this.memorySize.text.getText());
    }

    private TextFieldOption createMemorySizeOption(Memory[] memories, int defaultMemIndex, long defaultSize, String propertyHeader) {
        TextFieldOption text = new TextFieldOption((ILabel)this.label, String.valueOf(propertyHeader) + PROPERTY_SIZE);
        text.setInitialValue(Long.toString(defaultSize));
        if (this.canDisable()) {
            assert (memories.length > 1);
            text.setEnableCondition((Expression)new UnaryExpression(1, (Expression)new ComboMatchingIndexes((ComboOption)this.getMemoriesOptionAsCombo(), new int[1])));
        }
        return text;
    }
}

