/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.core;

import com.is2t.microej.workbench.ext.pages.core.MemoryPage;
import com.is2t.microej.workbench.ext.pages.emb.EmbMessages;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.ext.validator.IntIntervalOptionValidator;
import com.is2t.microej.workbench.ext.widget.ChangeLabelOption;
import com.is2t.microej.workbench.ext.widget.HiddenOptionForSize;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;

public class ThreadManagementGroup
extends LabelGroup {
    protected TextFieldOption nbThreads;
    protected TextFieldOption javaStackSize;
    protected HiddenOptionForSize hiddenJavaStackSize;
    protected ChangeLabelOption nativeStackSpace;

    public ThreadManagementGroup(String label, PageContent[] elements, int nbCols) {
        super(label, elements, nbCols);
    }

    public void initialize(TextFieldOption javaStackSize, HiddenOptionForSize hiddenJavaStackSize, TextFieldOption nbThreads, ChangeLabelOption nativeStackSpace) {
        this.nbThreads = nbThreads;
        this.javaStackSize = javaStackSize;
        this.hiddenJavaStackSize = hiddenJavaStackSize;
        this.nativeStackSpace = nativeStackSpace;
    }

    public void addOptionChangedListener(OptionChangedListener listener) {
        this.javaStackSize.addOptionChangedListener(listener);
        this.nbThreads.addOptionChangedListener(listener);
    }

    public long getMemoryValue(MemoryPage page) {
        int nbThreads = Tools.parseInt(this.nbThreads.getSelection());
        long javaStack = this.hiddenJavaStackSize.getValue();
        long nativeStack = page.getMemoryValue(6);
        long totalSize = (long)nbThreads * (javaStack + nativeStack);
        return totalSize;
    }

    public long getNativeMemory(MemoryPage page) {
        int nbThreads = Tools.parseInt(this.nbThreads.getSelection());
        long nativeStack = page.getMemoryValue(6);
        return (long)nbThreads * nativeStack;
    }

    public OptionValidator getMemoryOptionValidator(MemoryPage page) {
        final IntIntervalOptionValidator nbThreadsValidator = new IntIntervalOptionValidator(EmbMessages.LabelNbThreads, 1, true);
        return new OptionValidator(){

            public String getErrorMessage(PageContent arg0) {
                String message = ThreadManagementGroup.this.hiddenJavaStackSize.getErrorMessage(arg0);
                if (message != null) {
                    return message;
                }
                message = nbThreadsValidator.getErrorMessage((PageContent)ThreadManagementGroup.this.nbThreads);
                if (message != null) {
                    return message;
                }
                return null;
            }
        };
    }

    public void setOptionChangedListener(final MemoryPage page) {
        OptionChangedListener threadSizeModifier = new OptionChangedListener(){

            public void changed() {
                try {
                    String nat = Tools.getHumanReadableMemorySize(ThreadManagementGroup.this.getNativeMemory(page));
                    ThreadManagementGroup.this.nativeStackSpace.setText(nat);
                }
                catch (Exception exception) {}
            }
        };
        this.addOptionChangedListener(threadSizeModifier);
    }
}

