/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.core;

import com.is2t.microej.workbench.ext.pages.core.CoreMessages;
import com.is2t.microej.workbench.ext.pages.core.OutputMemoryPart;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.ext.validator.IntOptionValidator;
import com.is2t.microej.workbench.ext.widget.ChangeLabelOption;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;

public abstract class IceOSManagementGroup
implements OptionChangedListener {
    protected LabelOption threadsNumberLabel = new LabelOption(CoreMessages.IceOSThreadsNumber);
    protected LabelOption monitorsNumberLabel;
    protected LabelOption alarmsNumberLabel;
    protected TextFieldOption threadsNumberTextField = new TextFieldOption((ILabel)new StringLabel(""), "iceos.threads.number");
    protected TextFieldOption monitorsNumberTextField;
    protected TextFieldOption alarmsNumberTextField;
    protected ChangeLabelOption threadsSizeLabel;
    protected ChangeLabelOption monitorsSizeLabel;
    protected ChangeLabelOption alarmsSizeLabel;
    private long threadsSize;
    private long monitorsSize;
    private long alarmsSize;
    protected ChangeLabelOption totalSize;
    protected OutputMemoryPart memoryPart;

    public IceOSManagementGroup(OutputMemoryPart memoryPart) {
        this.threadsNumberTextField.setInitialValue(Integer.toString(this.getDefaultThreadsNumber()));
        this.threadsNumberTextField.setOptionValidator((OptionValidator)new IntOptionValidator(CoreMessages.IceOSThreadsNumber, false));
        this.monitorsNumberLabel = new LabelOption(CoreMessages.IceOSMonitorsNumber);
        this.monitorsNumberTextField = new TextFieldOption((ILabel)new StringLabel(""), "iceos.monitors.number");
        this.monitorsNumberTextField.setInitialValue(Integer.toString(this.getDefaultMonitorsNumber()));
        this.monitorsNumberTextField.setOptionValidator((OptionValidator)new IntOptionValidator(CoreMessages.IceOSMonitorsNumber, false));
        this.alarmsNumberLabel = new LabelOption(CoreMessages.IceOSAlarmsNumber);
        this.alarmsNumberTextField = new TextFieldOption((ILabel)new StringLabel(""), "iceos.alarms.number");
        this.alarmsNumberTextField.setInitialValue(Integer.toString(this.getDefaultAlarmsNumber()));
        this.alarmsNumberTextField.setOptionValidator((OptionValidator)new IntOptionValidator(CoreMessages.IceOSAlarmsNumber, false));
        this.threadsSizeLabel = new ChangeLabelOption("");
        this.monitorsSizeLabel = new ChangeLabelOption("");
        this.alarmsSizeLabel = new ChangeLabelOption("");
        this.totalSize = new ChangeLabelOption("");
        this.memoryPart = memoryPart;
    }

    public Group createGroup() {
        LabelOption equal = new LabelOption(CoreMessages.IceOSEqual);
        LabelOption total = new LabelOption(CoreMessages.IceOSTotalSize);
        LabelOption empty = new LabelOption("");
        this.threadsNumberTextField.addOptionChangedListener((OptionChangedListener)this);
        this.monitorsNumberTextField.addOptionChangedListener(new OptionChangedListener(){

            public void changed() {
                try {
                    int number = Tools.parseInt(IceOSManagementGroup.this.monitorsNumberTextField.getSelection());
                    IceOSManagementGroup.this.monitorsSize = number * IceOSManagementGroup.this.getMonitorSize();
                    IceOSManagementGroup.this.monitorsSizeLabel.setText(Tools.getHumanReadableMemorySize(IceOSManagementGroup.this.monitorsSize));
                    IceOSManagementGroup.this.updateTotalSize();
                }
                catch (Throwable throwable) {}
            }
        });
        this.alarmsNumberTextField.addOptionChangedListener(new OptionChangedListener(){

            public void changed() {
                try {
                    int number = Tools.parseInt(IceOSManagementGroup.this.alarmsNumberTextField.getSelection());
                    IceOSManagementGroup.this.alarmsSize = number * IceOSManagementGroup.this.getAlarmSize();
                    IceOSManagementGroup.this.alarmsSizeLabel.setText(Tools.getHumanReadableMemorySize(IceOSManagementGroup.this.alarmsSize));
                    IceOSManagementGroup.this.updateTotalSize();
                }
                catch (Throwable throwable) {}
            }
        });
        PageContent[] elements = new PageContent[]{this.threadsNumberLabel, this.threadsNumberTextField, equal, this.threadsSizeLabel, this.monitorsNumberLabel, this.monitorsNumberTextField, equal, this.monitorsSizeLabel, this.alarmsNumberLabel, this.alarmsNumberTextField, equal, this.alarmsSizeLabel, empty, empty, total, this.totalSize};
        return new LabelGroup(CoreMessages.IceOSGroupName, elements, 4);
    }

    private void updateTotalSize() {
        long size = this.threadsSize + this.monitorsSize + this.alarmsSize;
        String sizeText = Tools.getHumanReadableMemorySize(size);
        this.totalSize.setText(sizeText);
        this.memoryPart.memoryLabel.setText(sizeText);
    }

    public void changed() {
        try {
            int number = Tools.parseInt(this.threadsNumberTextField.getSelection());
            this.threadsSize = number * this.getThreadSize();
            this.threadsSizeLabel.setText(Tools.getHumanReadableMemorySize(this.threadsSize));
            this.updateTotalSize();
        }
        catch (Throwable throwable) {}
    }

    protected abstract int getThreadSize();

    protected abstract int getMonitorSize();

    protected abstract int getAlarmSize();

    protected abstract int getDefaultThreadsNumber();

    protected abstract int getDefaultMonitorsNumber();

    protected abstract int getDefaultAlarmsNumber();
}

