/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages;

import com.is2t.microej.workbench.ext.CommonMessages;
import com.is2t.microej.workbench.ext.Page2;
import com.is2t.microej.workbench.ext.pages.sim.SimMessages;
import com.is2t.microej.workbench.ext.validator.IntIntervalOptionValidator;
import com.is2t.microej.workbench.ext.validator.IntOptionValidator;
import com.is2t.microej.workbench.ext.validator.TextFieldOptionValidator;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.BooleanConstant;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import java.io.InputStream;
import java.util.Properties;

public class S3Page
extends Page2 {
    private static final String S3_PROPERTIES_FILE = "/s3.properties";
    public Group options;
    public Group hil;
    public CheckBoxOption boardCompliant;
    public TextFieldOption hilConnectionPort;
    public static final String PREFIX_JAVA_MEMORY = "S3.JavaMemory.";
    public static final int DEFAULT_APPLICATION_CHARS_SIZE = 4096;
    public static final int DEFAULT_METHODS_SIZE = 10000;
    public static final String METHODS_SIZE_KEY = "S3.JavaMemory.MethodsSize";
    public static final String APPLICATION_CHARS_SIZE_KEY = "S3.JavaMemory.ApplicationCharsSize";

    public S3Page() {
        super(null);
    }

    public static CheckBoxOption getBoardCompliant() {
        Page2 s3 = (Page2)Table.get(S3Page.class);
        return s3 != null ? ((S3Page)s3).boardCompliant : null;
    }

    @Override
    protected Group getCategoryPageGroup() {
        this.options = this.buildS3OptionsGroup();
        return new Group((PageContent[])new Group[]{this.options, this.hil = this.buildS3HILGroup()}, 1);
    }

    @Override
    protected String getCategoryPageName() {
        return CommonMessages.CategoryS3;
    }

    @Override
    protected Expression getCategoryPageVisibilityExpression() {
        return this.simBuild;
    }

    public Group buildS3OptionsGroup() {
        PageContent[] pageContents;
        TextFieldOption slowingFactor = new TextFieldOption((ILabel)new StringLabel(SimMessages.LabelS3Slow), "s3.slow");
        slowingFactor.setOptionValidator((OptionValidator)new IntOptionValidator(SimMessages.LabelS3Slow));
        slowingFactor.setInitialValue("0");
        slowingFactor.setDescription((Description)new XHTMLDescription(SimMessages.DocumentDescriptionS3SlowingFactor));
        final boolean forceBoardCompliance = this.forceBoardCompliance();
        boolean forceNoBoardCompliance = this.forceNoBoardCompliance();
        if (this.buildBoardCompliant() || forceBoardCompliance || forceNoBoardCompliance) {
            this.boardCompliant = new CheckBoxOption((ILabel)new StringLabel(SimMessages.LabelS3BoardCompliant), "s3.board.compliant");
            if (forceBoardCompliance) {
                this.boardCompliant.setInitialValue(true);
            } else if (forceNoBoardCompliance) {
                this.boardCompliant.setInitialValue(false);
            } else {
                this.boardCompliant.setInitialValue(false);
            }
            HiddenOption forceOption = new HiddenOption("", "s3.board.compliant.force", "");
            if (forceBoardCompliance || forceNoBoardCompliance) {
                this.boardCompliant.setEnableCondition((Expression)BooleanConstant.FALSE);
                forceOption.setOptionValidator(new OptionValidator(){

                    public String getErrorMessage(PageContent arg0) {
                        boolean expected;
                        boolean bl = expected = forceBoardCompliance;
                        if (S3Page.this.boardCompliant.getSelection() != expected) {
                            return forceBoardCompliance ? SimMessages.LabelS3BoardCompliantForceAvailable : SimMessages.LabelS3BoardCompliantForceUnavailable;
                        }
                        return null;
                    }
                });
            }
            this.boardCompliant.setDescription((Description)new XHTMLDescription(SimMessages.DocumentDescriptionS3BoardCompliant));
            pageContents = new PageContent[]{this.boardCompliant, slowingFactor, forceOption};
        } else {
            pageContents = new PageContent[]{slowingFactor};
        }
        LabelGroup grp = new LabelGroup(SimMessages.GroupS3Options, pageContents, 1);
        grp.setDescription((Description)new XHTMLDescription(SimMessages.DocumentDescriptionS3Group));
        return grp;
    }

    public Group buildS3HILGroup() {
        CheckBoxOption useS3HILPort = new CheckBoxOption((ILabel)new StringLabel(SimMessages.LabelS3UseHILPort), "s3.hil.use.port");
        useS3HILPort.setInitialValue(false);
        useS3HILPort.setDescription((Description)new XHTMLDescription(SimMessages.DocumentDescriptionS3UseHILPort));
        this.hilConnectionPort = new TextFieldOption((ILabel)new StringLabel(SimMessages.LabelS3HilConnectionPort), "s3.hil.port");
        this.hilConnectionPort.setOptionValidator((OptionValidator)new IntIntervalOptionValidator(SimMessages.LabelS3HilConnectionPort, 1024, 65535));
        this.hilConnectionPort.setInitialValue("8001");
        this.hilConnectionPort.setEnableCondition((Expression)new CheckBoxSelected(useS3HILPort));
        TextFieldOption hilConnectionTimeout = new TextFieldOption((ILabel)new StringLabel(SimMessages.LabelS3HilConnectionTimeout), "s3.hil.timeout");
        hilConnectionTimeout.setOptionValidator((OptionValidator)new IntOptionValidator(SimMessages.LabelS3HilConnectionTimeout));
        hilConnectionTimeout.setInitialValue("10");
        TextFieldOption hilConnectionMaxFrameSize = new TextFieldOption((ILabel)new StringLabel(SimMessages.LabelS3HilConnectionMaxFrameSize), "com.microej.simulator.hil.frame.size");
        hilConnectionMaxFrameSize.setOptionValidator((OptionValidator)new IntOptionValidator(SimMessages.LabelS3HilConnectionTimeout));
        hilConnectionMaxFrameSize.setInitialValue("262144");
        Group hilConnectionSubGroup = new Group(new PageContent[]{useS3HILPort, this.hilConnectionPort, hilConnectionTimeout, hilConnectionMaxFrameSize}, 1);
        LabelGroup hilConnectionGroup = new LabelGroup(SimMessages.GroupS3HILConnection, new PageContent[]{hilConnectionSubGroup}, 1);
        this.hilConnectionPort.setDescription((Description)new XHTMLDescription(SimMessages.DocumentDescriptionS3HILPort));
        hilConnectionTimeout.setDescription((Description)new XHTMLDescription(SimMessages.DocumentDescriptionS3HILTimeout));
        hilConnectionGroup.setDescription((Description)new XHTMLDescription(SimMessages.DocumentDescriptionS3HILGroup));
        hilConnectionMaxFrameSize.setDescription((Description)new XHTMLDescription(SimMessages.DocumentDescriptionS3HilConnectionMaxFrameSize));
        return hilConnectionGroup;
    }

    protected boolean buildBoardCompliant() {
        return true;
    }

    protected boolean forceBoardCompliance() {
        return this.getProperty("s3.board.compliant.force", "unset").equals("true");
    }

    private boolean forceNoBoardCompliance() {
        return this.getProperty("s3.board.compliant.force", "unset").equals("false");
    }

    private String getProperty(String key, String defaultValue) {
        Properties p = this.getInternProperties();
        String res = (String)p.get(key);
        if (res == null) {
            res = defaultValue;
        }
        return res;
    }

    private Properties getInternProperties() {
        Properties properties = new Properties();
        InputStream is = this.getClass().getResourceAsStream(S3_PROPERTIES_FILE);
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (Throwable throwable) {}
        }
        return properties;
    }

    protected Group buildJavaMemorySizesGroup() {
        TextFieldOption appCharsSize = new TextFieldOption((ILabel)new StringLabel(SimMessages.LabelS3ApplicationCharsSize), APPLICATION_CHARS_SIZE_KEY);
        appCharsSize.setOptionValidator((OptionValidator)new TextFieldOptionValidator(SimMessages.LabelS3ApplicationCharsSize));
        appCharsSize.setInitialValue(String.valueOf(4096));
        appCharsSize.setDescription((Description)new XHTMLDescription(SimMessages.DocumentDescriptionS3PropertyApplicationCharsSize));
        appCharsSize.setOptionValidator((OptionValidator)new IntOptionValidator(SimMessages.LabelS3ApplicationCharsSize, false));
        TextFieldOption methodSize = new TextFieldOption((ILabel)new StringLabel(SimMessages.LabelS3MethodsSize), METHODS_SIZE_KEY);
        methodSize.setOptionValidator((OptionValidator)new TextFieldOptionValidator(SimMessages.LabelS3MethodsSize));
        methodSize.setInitialValue(String.valueOf(10000));
        methodSize.setDescription((Description)new XHTMLDescription(SimMessages.DocumentDescriptionS3PropertyMethodsSize));
        methodSize.setOptionValidator((OptionValidator)new IntOptionValidator(SimMessages.LabelS3MethodsSize, false));
        PageContent[] pageContents = new PageContent[]{appCharsSize, methodSize};
        return new LabelGroup(SimMessages.LabelS3JavaMemorySizes, pageContents, 1);
    }
}

