/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.ant.kf.tools.classpath;

import com.is2t.ant.kf.tools.classpath.kfAntToolsA;
import com.is2t.soar.reader.IDebugSoarFileReader;
import com.is2t.soar.reader.IDebugSoarFileReaderSet;
import com.is2t.soar.reader.ImageReadException;
import com.is2t.soar.world.IJavaModelFactory;
import com.is2t.soar.world.IJavaType;
import com.is2t.soar.world.ISoarWorld;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ServiceLoader;
import kfAntTools.kfAntToolsC;
import kfAntTools.kfAntToolsF;
import kfAntTools.kfAntToolsJ;
import kfAntTools.kfAntToolsK;
import kfAntTools.kfAntToolsL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class APIClasspathExtractorTask
extends Task {
    private static final String DEFAULT_READER_FORMAT = "elf";
    private static final String CLASSFILE_EXTENSION = ".class";
    public String kernelFilename;
    private boolean isBigEndian;
    private String readerFormat = "elf";
    public String classpath = "";
    public char pathSeparator;
    private String outputAPIClasspathProperty;
    private String outputNotAPIClasspathProperty;
    private final ServiceLoader readerSet = ServiceLoader.load(IDebugSoarFileReaderSet.class, this.getSoarModelClassloader());
    private ClassLoader soarModelClassloader;
    private boolean verbose;
    private final kfAntToolsJ errorHandler = new kfAntToolsJ();
    private String[] excludeTypes;
    private final ServiceLoader javaModelSet = ServiceLoader.load(IJavaModelFactory.class, this.getSoarModelClassloader());

    public APIClasspathExtractorTask() {
        this.pathSeparator = System.getProperty("path.separator").charAt(0);
        this.excludeTypes = new String[0];
    }

    public void setOutputAPIClasspathProperty(String string) {
        this.outputAPIClasspathProperty = string;
    }

    public void setOutputNotAPIClasspathProperty(String string) {
        this.outputNotAPIClasspathProperty = string;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setKernelFilename(String string) {
        this.kernelFilename = string;
    }

    public void setReaderFormat(String string) {
        this.readerFormat = string;
    }

    public void setEndianness(String string) {
        if (string.equalsIgnoreCase("little")) {
            this.isBigEndian = false;
            return;
        }
        this.isBigEndian = true;
    }

    public void setPathSeparator(String string) {
        if ((string = string.trim()).length() == 1) {
            this.pathSeparator = string.charAt(0);
        }
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public IDebugSoarFileReader getDebugSoarFileReader(String string) {
        for (IDebugSoarFileReaderSet iDebugSoarFileReaderSet : this.readerSet) {
            if ((iDebugSoarFileReaderSet = iDebugSoarFileReaderSet.getReader(string)) == null) continue;
            return iDebugSoarFileReaderSet;
        }
        return null;
    }

    private ClassLoader getSoarModelClassloader() {
        if (this.soarModelClassloader != null) {
            return this.soarModelClassloader;
        }
        String string = System.getProperty("com.is2t.ant.kf.tools.classpath.soarmodel.path");
        ClassLoader classLoader = null;
        if (string != null) {
            try {
                classLoader = new URLClassLoader(new URL[]{new File(string).toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (Throwable throwable) {
                throw new AssertionError((Object)throwable);
            }
        }
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        this.soarModelClassloader = classLoader;
        return this.soarModelClassloader;
    }

    public ISoarWorld initVMImage() {
        try {
            IDebugSoarFileReader iDebugSoarFileReader = this.getDebugSoarFileReader(this.readerFormat);
            if (iDebugSoarFileReader == null) {
                throw new ImageReadException();
            }
            iDebugSoarFileReader.setBigEndianness(this.isBigEndian);
            return iDebugSoarFileReader.read(this.kernelFilename);
        }
        catch (ImageReadException imageReadException) {
            Object object = this.kernelFilename;
            Object object2 = new kfAntTools.kfAntToolsA();
            new kfAntTools.kfAntToolsA().a = 1;
            ((kfAntTools.kfAntToolsA)object2).b = new String[]{object};
            object = object2;
            object2 = this.errorHandler;
            ((kfAntToolsJ)object2).a(null, null, (kfAntToolsL)object);
            return null;
        }
    }

    public IJavaModelFactory getJavaModel() {
        IJavaModelFactory iJavaModelFactory = this.javaModelSet.iterator();
        if (iJavaModelFactory.hasNext()) {
            iJavaModelFactory = (IJavaModelFactory)iJavaModelFactory.next();
            return iJavaModelFactory;
        }
        return null;
    }

    public void execute() {
        try {
            this.execute0();
        }
        catch (Throwable throwable) {
            Object object = throwable;
            throwable.printStackTrace();
            kfAntToolsK kfAntToolsK2 = new kfAntToolsK().a(-1);
            object = this.errorHandler;
            ((kfAntToolsJ)object).a(null, null, kfAntToolsK2);
        }
        boolean bl = this.errorHandler.b();
        this.errorHandler.a();
        if (bl) {
            throw new BuildException("Terminated with errors");
        }
    }

    private void setProperty(String stringArray, ArrayList object) {
        Project project = this.getProject();
        String[] stringArray2 = stringArray;
        object = String.valueOf(this.pathSeparator);
        stringArray = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length - 1;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append((String)object);
        }
        if (n >= 0) {
            stringBuilder.append(stringArray[n]);
        }
        project.setProperty((String)stringArray2, stringBuilder.toString());
    }

    private void execute0() {
        Object object;
        IJavaType iJavaType;
        int n;
        Object[] objectArray = kfAntToolsC.a(this.classpath, this.pathSeparator);
        Object object2 = this.initVMImage();
        if (object2 == null) {
            return;
        }
        HashMap<Object, IJavaType> hashMap = new HashMap<Object, IJavaType>();
        IJavaType[] iJavaTypeArray = object2.getAllTypes();
        object2 = iJavaTypeArray;
        object2 = iJavaTypeArray;
        int n2 = iJavaTypeArray.length;
        for (n = 0; n < n2; ++n) {
            iJavaType = object2[n];
            if (!this.isAPI(iJavaType)) continue;
            String string = iJavaType.getName();
            if (string.startsWith("[")) {
                object = "[L";
                if (!string.startsWith((String)object)) continue;
                int n3 = ((String)object).length();
                string = string.substring(n3, string.length() - 1);
            } else if (string.startsWith("L")) {
                string = string.substring(1, string.length() - 1);
            } else {
                throw new AssertionError();
            }
            object = string + CLASSFILE_EXTENSION;
            hashMap.put(object, iJavaType);
        }
        object2 = this.excludeTypes;
        n2 = this.excludeTypes.length;
        for (n = 0; n < n2; ++n) {
            iJavaType = object2[n];
            hashMap.remove(iJavaType.replace('.', '/') + CLASSFILE_EXTENSION);
        }
        if (this.errorHandler.b()) {
            return;
        }
        object2 = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        kfAntToolsF[] kfAntToolsFArray = objectArray;
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            object = kfAntToolsFArray[i];
            kfAntToolsA kfAntToolsA2 = new kfAntToolsA(this, hashMap, (kfAntToolsF)object);
            objectArray = ((kfAntToolsF)object).b(kfAntToolsA2);
            object = ((kfAntToolsF)object).a().getAbsolutePath();
            if (objectArray.length > 0) {
                ((ArrayList)object2).add(object);
                continue;
            }
            arrayList.add(object);
        }
        this.setProperty(this.outputAPIClasspathProperty, (ArrayList)object2);
        this.setProperty(this.outputNotAPIClasspathProperty, arrayList);
    }

    private boolean isAPI(IJavaType object) {
        try {
            return object.isAPI();
        }
        catch (AbstractMethodError abstractMethodError) {
            if (!this.errorHandler.b()) {
                object = new kfAntTools.kfAntToolsA();
                new kfAntTools.kfAntToolsA().a = 6;
                object.b = new String[0];
                Object object2 = object;
                object = this.errorHandler;
                object.a(null, null, (kfAntToolsL)object2);
            }
            return false;
        }
    }

    public void setExcludeTypes(String string) {
        this.excludeTypes = APIClasspathExtractorTask.splitAndRemoveEmpty(string, ',');
    }

    public static String[] splitAndRemoveEmpty(String string, char c) {
        return APIClasspathExtractorTask.removeEmptyElement(string.split(String.valueOf(c)));
    }

    private static String[] removeEmptyElement(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            ++n;
        }
        if (n == stringArray.length) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            stringArray2[++n] = stringArray[i];
        }
        return stringArray2;
    }

    static /* synthetic */ boolean access$000(APIClasspathExtractorTask aPIClasspathExtractorTask) {
        return aPIClasspathExtractorTask.verbose;
    }
}

