/*
 * Decompiled with CFR 0.152.
 */
package ist.generic.error;

import com.militsa.tools.SimpleVector;
import ist.generic.error.ErrorDescription;
import ist.generic.error.MilitsaError;
import ist.generic.error.MilitsaErrorHandler;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorTaskContainer {
    private SimpleVector errorDescriptions = new SimpleVector();
    public boolean omitWarnings;

    public ErrorDescription createErrorDescription() {
        ErrorDescription error = new ErrorDescription();
        this.errorDescriptions.add(error);
        return error;
    }

    public void setOmitWarnings(boolean value) {
        this.omitWarnings = value;
    }

    public void outputError(MilitsaErrorHandler errorHandler) {
        Object[] expectedErrors = new ErrorDescription[this.errorDescriptions.nbObjects()];
        this.errorDescriptions.copyToArray(expectedErrors);
        int expectedErrorPtr = -1;
        int nbErrors = errorHandler.currentNotification + 1;
        MilitsaError[] errors = errorHandler.allKindOfNotifications;
        char[][] sources = errorHandler.sources;
        String[] filenames = errorHandler.filenames;
        int i = -1;
        while (++i < nbErrors) {
            Object expectedError;
            MilitsaError error = errors[i];
            try {
                expectedError = expectedErrors[++expectedErrorPtr];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (this.omitWarnings) {
                    int ptr = nbErrors;
                    while (--ptr >= expectedErrorPtr) {
                        if (!errors[ptr].isFatal()) continue;
                        throw new RuntimeException("Not enough declared expected errors");
                    }
                    return;
                }
                throw new RuntimeException("Not enough declared expected errors");
            }
            if (((ErrorDescription)expectedError).kind != error.kind) {
                if (this.omitWarnings && error.isWarning()) {
                    --expectedErrorPtr;
                    continue;
                }
                throw new RuntimeException("Invalid Error (" + error.kind + ", expected " + ((ErrorDescription)expectedError).kind + ")");
            }
            if (((ErrorDescription)expectedError).errorName != null && !error.outputName().equalsIgnoreCase(((ErrorDescription)expectedError).errorName)) {
                throw new RuntimeException("Invalid error name: " + ((ErrorDescription)expectedError).errorName + ", expected " + error.outputName());
            }
            if (((ErrorDescription)expectedError).matchMessage != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(1000);
                PrintStream ps = new PrintStream(stream);
                errorHandler.dump(ps, error, i, sources[i], filenames[i]);
                Pattern p = Pattern.compile(((ErrorDescription)expectedError).matchMessage, 40);
                Matcher m = p.matcher(new String(stream.toByteArray()));
                if (!m.matches()) {
                    errorHandler.dump(System.out, error, i, sources[i], filenames[i]);
                    throw new RuntimeException("Previous error does not match: " + ((ErrorDescription)expectedError).matchMessage);
                }
            }
            errorHandler.dump(System.out, error, i, sources[i], filenames[i]);
        }
        if (expectedErrorPtr + 1 != expectedErrors.length) {
            throw new RuntimeException("Too many declared expected errors");
        }
    }
}

