/*
 * Decompiled with CFR 0.152.
 */
package ist.generic;

import ist.generic.Options;
import ist.generic.ProgressIndicator;
import ist.generic.error.InternalMilitsaError;
import ist.generic.error.MilitsaError;
import ist.generic.error.MilitsaErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class Product {
    public Options options;
    public ProgressIndicator progressIndicator;
    public MilitsaErrorHandler errorHandler;
    private static final String ProductFilename = "product.properties";
    private static final String PropertyProductName = "product.printable.name";
    private static final String PropertyProductVersion = "product.version";
    private String version;

    public void batchRun(String[] commandLine) {
        boolean sanityCheck = false;
        int i = commandLine.length;
        while (--i >= 0) {
            if (!commandLine[i].equals("-sanityCheck") && !commandLine[i].equals("-istSpecialMode")) continue;
            sanityCheck = true;
            break;
        }
        boolean endsWithErrors = false;
        if (sanityCheck) {
            endsWithErrors = this.batchRun0(commandLine);
        } else {
            int errorCode = 0;
            try {
                endsWithErrors = this.batchRun0(commandLine);
            }
            catch (OutOfMemoryError e) {
                errorCode = -1;
            }
            catch (StackOverflowError e) {
                errorCode = -2;
            }
            catch (Throwable e) {
                errorCode = -3;
            }
            if (errorCode != 0) {
                System.out.println(MilitsaError.messageAt(0, null, InternalMilitsaError.messages));
                System.out.println("Error code = " + errorCode);
                System.out.println("Contact IS2T support");
                System.exit(-1);
            }
        }
        if (endsWithErrors) {
            System.exit(1);
        }
    }

    public abstract void initialize();

    public abstract Options newOptions();

    public abstract MilitsaErrorHandler newErrorHandler();

    public abstract void run();

    public void batchRunIsDone() {
    }

    private boolean batchRun0(String[] commandLine) {
        this.initialize();
        this.options = this.newOptions();
        this.errorHandler = this.newErrorHandler();
        this.progressIndicator = new ProgressIndicator(1);
        try {
            if (!this.options.setOptionsFrom(commandLine)) {
                this.abortOnError();
                return true;
            }
        }
        catch (MilitsaError e) {
            this.errorHandler.addNoFile(e);
        }
        if (this.errorHandler != null && this.errorHandler.outputError()) {
            this.abortOnError();
            return true;
        }
        this.run();
        boolean endsWithErrors = false;
        if (this.errorHandler != null) {
            endsWithErrors = this.errorHandler.outputError();
        }
        this.batchRunIsDone();
        return endsWithErrors;
    }

    protected void abortOnError() {
        System.out.print(this.productNameAndVersion());
        System.out.println(" - " + this.copyright());
        this.options.printUsage(System.out);
    }

    public String productNameAndVersion() {
        if (this.version != null) {
            return this.version;
        }
        InputStream is = this.getClass().getResourceAsStream(ProductFilename);
        String productName = null;
        String productVersion = null;
        if (is != null) {
            Properties p = new Properties();
            try {
                p.load(is);
            }
            catch (IOException e) {
                // empty catch block
            }
            productName = (String)p.get(PropertyProductName);
            productVersion = (String)p.get(PropertyProductVersion);
        }
        if (productName == null) {
            productName = "Unknown product";
        }
        if (productVersion == null) {
            productVersion = "Unknown version";
        }
        this.version = productName + " - " + productVersion;
        return this.version;
    }

    public String copyright() {
        int yearStart = this.getCopyrightYearStart();
        int yearStop = this.getCopyrightYearStop();
        return "(c) IS2T - " + yearStart + (yearStop != yearStart ? "-" + yearStop : "");
    }

    public int getCopyrightYearStart() {
        return 2004;
    }

    public int getCopyrightYearStop() {
        return 2013;
    }

    public boolean canVerbose(int level, boolean intern) {
        Options options = this.options;
        if (intern) {
            return false;
        }
        return level <= options.verbose;
    }

    public void verbose(int level, String text) {
        this.verbose(level, text, false);
    }

    public void verbose(int level, String text, boolean intern) {
        if (this.canVerbose(level, intern)) {
            System.out.println("INFO: " + text);
        }
    }
}

