/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.xmlParserGenerator.filewriter;

import com.militsa.xmlParserGenerator.XmlParserGenerator;
import com.militsa.xmlParserGenerator.XmlParserGeneratorOption;
import com.militsa.xmlParserGenerator.descriptor.XmlAttributeDescriptor;
import com.militsa.xmlParserGenerator.descriptor.XmlElementDescriptor;
import com.militsa.xmlParserGenerator.filewriter.IceTeaParserFileConstant;
import java.io.FileWriter;
import java.io.IOException;

public class IceTeaXmlElementWriter
implements IceTeaParserFileConstant {
    public static int xmlElementId;
    public XmlParserGeneratorOption option;

    public IceTeaXmlElementWriter(XmlParserGeneratorOption option) {
        this.option = option;
        xmlElementId = 0;
    }

    public void generateXmlTagFile() {
        try {
            String xmlTagClassname = this.option.getClassName("XmlTag");
            String filename = this.option.getFullFileName(xmlTagClassname);
            FileWriter fw = new FileWriter(filename);
            fw.write(this.option.getCopyrightHeader());
            fw.write("package " + this.option.outputPackage + " ;\n");
            fw.write("public abstract class " + xmlTagClassname + " {\n");
            fw.write("\tpublic int id ;\n");
            fw.write("\tpublic char[] data ;\n");
            fw.write("\tpublic int startPosition ;\n");
            fw.write("\tpublic int stopPosition ;\n");
            fw.write("\tpublic " + xmlTagClassname + " " + "father" + " ;\n");
            fw.write("\tpublic " + xmlTagClassname + " " + "nextBrother" + " ;\n");
            fw.write("\tpublic " + xmlTagClassname + " " + "firstChild" + " ;\n");
            fw.write("\tpublic " + xmlTagClassname + " " + "lastChild" + " ;\n");
            String tabs = "\t";
            fw.write(tabs + "public " + xmlTagClassname + "( int " + "id" + ", int " + "startPosition" + ") {\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "this." + "id" + " = " + "id" + ";\n");
            fw.write(tabs + "this." + "startPosition" + " = " + "startPosition" + ";\n");
            fw.write(tabs + "this." + "stopPosition" + " = -1;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            this.generateDisposeMethod(fw, "\t");
            fw.write("\n");
            this.generateDisposeSubTreeTagMethod(fw, "\t");
            fw.write("\n");
            this.generateFillSubTree(fw, "\t");
            fw.write("\n");
            this.generateGetNbSubXmlTag(fw, "\t");
            fw.write("\n");
            this.generateAddChildMethod(fw, "\t");
            fw.write("\n");
            fw.write(tabs + "public abstract " + "String" + " " + "getName" + "() ;\n");
            fw.write(tabs + "protected abstract String " + "getAttributeValue" + "() ;\n");
            fw.write(tabs + "protected abstract void " + "freeFields" + "() ;\n");
            fw.write(tabs + "public abstract boolean[] " + "getOptionalAttributes" + "() ;\n");
            fw.write(tabs + "public abstract String " + "getAttributeNameAt" + "(int index) ;\n");
            fw.write(tabs + "public String " + "toString" + "(int " + "nbTabs" + ") {\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "StringBuilder" + " " + "sb" + " = new " + "StringBuilder" + "() ;\n");
            fw.write(tabs + "for (int i = " + "nbTabs" + " ; --i >= 0 ;)\n");
            fw.write(tabs + "\t" + "sb" + " = " + "sb" + "." + "append" + "('\\t') ;\n");
            fw.write(tabs + "sb" + " = " + "sb" + "." + "append" + "(" + "getName" + "())." + "append" + "(' ') ;\n");
            fw.write(tabs + "if (" + "data" + " != null) {\n");
            fw.write(tabs + "sb" + " = " + "sb" + "." + "append" + "(\"data = \\\"\") ;\n");
            fw.write(tabs + "int length = " + "data" + ".length ;\n");
            fw.write(tabs + "char" + "[] " + "data" + " = this." + "data" + " ;\n");
            fw.write(tabs + "for (int i = -1 ; ++i < length ;) {\n");
            fw.write(tabs + "\t" + "sb" + " = " + "sb" + "." + "append" + "((char)" + "data" + "[i]) ;\n");
            fw.write(tabs + "}\n");
            fw.write(tabs + "sb" + " = " + "sb" + "." + "append" + "(\"\\\" \") ;\n");
            fw.write(tabs + "}\n");
            fw.write(tabs + "String str = " + "getAttributeValue" + "() ;\n");
            fw.write(tabs + "sb" + " = " + "sb" + "." + "append" + "(str)." + "append" + "(' ')." + "append" + "('\\n') ;\n");
            fw.write(tabs + "delete str ;\n");
            fw.write(tabs + "if (" + "firstChild" + " != null) {\n");
            fw.write(tabs + "\t" + "str = " + "firstChild" + "." + "toString" + "(" + "nbTabs" + "+1) ;\n");
            fw.write(tabs + "\t" + "sb" + " = " + "sb" + "." + "append" + "(str) ;\n");
            fw.write(tabs + "\t" + "delete str ;\n");
            fw.write(tabs + "}\n");
            fw.write(tabs + "if (" + "nextBrother" + " != null) {\n");
            fw.write(tabs + "\t" + "str = " + "nextBrother" + "." + "toString" + "(" + "nbTabs" + ") ;\n");
            fw.write(tabs + "\t" + "sb" + " = " + "sb" + "." + "append" + "(str) ;\n");
            fw.write(tabs + "\t" + "delete str ;\n");
            fw.write(tabs + "}\n");
            fw.write(tabs + "return " + "sb" + "." + "toStringAndFree" + "() ;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            fw.write("}\n");
            fw.flush();
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void generateGetNbSubXmlTag(FileWriter fw, String string) throws IOException {
        String tabs = "\t";
        fw.write(tabs + "public int getNbSubXmlTag () {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "int nb=0;\n");
        fw.write(tabs + "if ( this.firstChild != null) \n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "nb =  firstChild.getNbSubXmlTag();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "if ( this.nextBrother != null) \n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "nb +=  nextBrother.getNbSubXmlTag();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "return ++nb;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void generateFillSubTree(FileWriter fw, String string) throws IOException {
        String tabs = "\t";
        fw.write(tabs + "public int fillSubTree( " + this.option.getClassName("XmlTag") + "[] list, int ptr) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "if ( this.firstChild != null)\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "ptr =  firstChild.fillSubTree( list, ptr);\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "if ( this.nextBrother != null) \n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "ptr =  nextBrother.fillSubTree( list, ptr);\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "list[++ptr] = this;\n");
        fw.write(tabs + "return ptr;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void generateDisposeSubTreeTagMethod(FileWriter fw, String string) throws IOException {
        String tabs = "\t";
        fw.write(tabs + "public void disposeSubTree() {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "//  dispose all XmlTag sub tree.\n");
        fw.write(tabs + "//  usually send on XmlTag root.\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "int ptr = -1;\n");
        fw.write(tabs + this.option.getClassName("XmlTag") + "[] list = new " + this.option.getClassName("XmlTag") + "[ getNbSubXmlTag()];\n");
        fw.write(tabs + "fillSubTree( list, ptr);\n");
        fw.write(tabs + "for (int j = list.length; --j >=0;) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "delete list[j];\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "};\n");
        fw.write(tabs + "delete list;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    public void generateDisposeMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public void dispose () {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "freeFields();\n");
        fw.write(tabs + "if ( data != null) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "delete ( data);\n");
        fw.write(tabs + "data = null;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "}\n");
    }

    public void generateXmlElementFile(XmlElementDescriptor element) {
        XmlElementDescriptor.coloredElements.atPut(element, new Object());
        try {
            int i;
            String name;
            XmlAttributeDescriptor attribute;
            String classname = this.option.getClassName("XmlElement" + element.getNameWithUpperChar());
            String filename = this.option.getFullFileName(classname);
            FileWriter fw = new FileWriter(filename);
            fw.write(this.option.getCopyrightHeader());
            fw.write("package " + this.option.outputPackage + " ;\n");
            fw.write("public class " + classname + " extends " + this.option.getClassName("XmlTag") + " {\n");
            int i2 = element.attributesPtr + 1;
            while (--i2 >= 0) {
                String name2 = XmlParserGenerator.getAttributeName(element.attributes[i2].name);
                fw.write("\tpublic char[] " + name2 + " ;\n");
                fw.write("\tpublic int " + name2 + "Start;\n");
                fw.write("\tpublic int " + name2 + "Stop;\n");
            }
            fw.write("\n");
            String tabs = "\t";
            fw.write(tabs + "public " + classname + "(int " + "id" + ", int " + "startPosition" + ") {\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "super(" + "id" + ", " + "startPosition" + ") ;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            fw.write("\n");
            fw.write(tabs + "public " + "String" + " " + "getName" + "() {\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "return \"" + element.name + "\" ;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            fw.write("\n");
            fw.write(tabs + "protected String " + "getAttributeValue" + "() {\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "StringBuilder" + " " + "sb" + " = new " + "StringBuilder" + "() ;\n");
            int i3 = -1;
            while (++i3 < element.attributesPtr + 1) {
                attribute = element.attributes[i3];
                name = XmlParserGenerator.getAttributeName(attribute.name);
                fw.write(tabs + "if (" + name + " != null) {\n");
                tabs = tabs.concat("\t");
                fw.write(tabs + "sb" + " = " + "sb" + "." + "append" + "(\"" + name + " = \\\"\") ;\n");
                fw.write(tabs + "int " + "_length" + " = " + name + ".length ;\n");
                fw.write(tabs + "for (int i = -1 ; ++i < " + "_length" + " ;)\n");
                fw.write(tabs + "\t" + "sb" + " = " + "sb" + "." + "append" + "((char)" + name + "[i]) ;\n");
                fw.write(tabs + "sb" + " = " + "sb" + "." + "append" + "(\"\\\" \") ;\n");
                tabs = tabs.substring(1);
                fw.write(tabs + "}\n");
            }
            fw.write(tabs + "return " + "sb" + "." + "toStringAndFree" + "() ;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            fw.write("\n");
            fw.write(tabs + "protected void " + "freeFields" + "() {\n");
            tabs = tabs.concat("\t");
            i3 = element.attributesPtr + 1;
            while (--i3 >= 0) {
                attribute = element.attributes[i3];
                name = XmlParserGenerator.getAttributeName(attribute.name);
                fw.write(tabs + "if (" + name + " != null)\n");
                fw.write(tabs + "\t" + "free" + "(" + name + ") ;\n");
            }
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            fw.write("\n");
            fw.write(tabs + "public boolean[] " + "getOptionalAttributes" + "() {\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "return new boolean[] { ");
            int end = element.attributesPtr;
            for (i = 0; i <= end; ++i) {
                if (element.attributes[i].optional) {
                    fw.write("true");
                } else {
                    fw.write("false");
                }
                if (i == end) continue;
                fw.write(", ");
            }
            fw.write("};\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            fw.write("\n");
            fw.write(tabs + "public String " + "getAttributeNameAt" + "( int index){\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "switch ( index) {\n");
            i = element.attributesPtr + 1;
            while (--i >= 0) {
                fw.write(tabs + "case " + i + ": return \"" + element.attributes[i].name + "\";\n");
            }
            fw.write(tabs + "default: return \"\";\n");
            fw.write(tabs + "}\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            fw.write("}\n");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        int i = element.elementsPtr + 1;
        while (--i >= 0) {
            XmlElementDescriptor childElem = element.elements[i];
            if (XmlElementDescriptor.coloredElements.at(childElem) != null) continue;
            this.generateXmlElementFile(childElem);
        }
    }

    public void generateXmlElementIdsFile(XmlElementDescriptor root) {
        try {
            String classname = this.option.getClassName("XmlElementIds");
            String filename = this.option.getFullFileName(classname);
            FileWriter fw = new FileWriter(filename);
            fw.write(this.option.getCopyrightHeader());
            fw.write("package " + this.option.outputPackage + " ;\n");
            fw.write("public interface " + classname + " {\n");
            this.generateXmlElementId(fw, "\t", root);
            fw.write("}\n");
            fw.flush();
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void generateXmlElementId(FileWriter fw, String tabs, XmlElementDescriptor element) throws IOException {
        XmlElementDescriptor.coloredElements.atPut(element, new Object());
        fw.write(tabs + "public static final int " + "xmlElement" + element.getNameWithUpperChar() + " = " + xmlElementId++ + " ;\n");
        int i = element.elementsPtr + 1;
        while (--i >= 0) {
            XmlElementDescriptor childElem = element.elements[i];
            if (XmlElementDescriptor.coloredElements.at(childElem) != null) continue;
            this.generateXmlElementId(fw, tabs, childElem);
        }
    }

    private void generateAddChildMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public void " + "addChild" + "(" + this.option.getClassName("XmlTag") + " " + "tag" + ") {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "if unlikely(" + "firstChild" + " == null) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "firstChild" + " = " + "tag" + " ;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "lastChild" + "." + "nextBrother" + " = " + "tag" + " ;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "lastChild" + " = " + "tag" + " ;\n");
        fw.write(tabs + "tag" + "." + "father" + " = this ;\n");
        fw.write(tabs + "tag" + "." + "nextBrother" + " = null ;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }
}

