/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.xmlParserGenerator.filewriter;

import com.militsa.tools.ObjectToObjectTable;
import com.militsa.xmlParserGenerator.TagNode;
import com.militsa.xmlParserGenerator.XmlParserGenerator;
import com.militsa.xmlParserGenerator.XmlParserGeneratorOption;
import com.militsa.xmlParserGenerator.descriptor.XmlAttributeDescriptor;
import com.militsa.xmlParserGenerator.descriptor.XmlElementDescriptor;
import com.militsa.xmlParserGenerator.filewriter.IceTeaParserFileConstant;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class IceTeaParserFileWriter
implements IceTeaParserFileConstant {
    public ObjectToObjectTable currentColoredElement;
    public int id;
    public XmlParserGeneratorOption option;
    public FileWriter tagIdFile;
    public FileWriter parserFile;

    public IceTeaParserFileWriter(XmlParserGeneratorOption option) {
        this.option = option;
        this.id = 0;
        try {
            File file = new File(option.outputDirectory + File.separatorChar + option.getOutputPackage());
            file.mkdirs();
            file = new File(option.outputDirectory + File.separatorChar + option.getOutputPackage());
            file.mkdirs();
            this.tagIdFile = new FileWriter(option.getFullFileName(option.getClassName("TagsId")));
            this.parserFile = new FileWriter(option.getFullFileName(option.getClassName("XmlParser")));
        }
        catch (IOException e) {
            System.out.println("File error");
            System.out.println(e.getMessage());
        }
    }

    public void generateTagIdFile(XmlElementDescriptor root) {
        try {
            FileWriter fw = this.tagIdFile;
            fw.write(this.option.getCopyrightHeader());
            fw.write("package " + this.option.outputPackage + " ;\n");
            fw.write("public interface " + this.option.getClassName("TagsId") + "{\n");
            this.currentColoredElement = new ObjectToObjectTable();
            this.generateElementId(root, fw);
            fw.write("}");
            fw.flush();
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void generateElementId(XmlElementDescriptor element, FileWriter fw) throws IOException {
        this.currentColoredElement.atPut(element, new Object());
        this.generateTagId(element.tagElements, fw);
        this.generateTagId(element.tagAttributes, fw);
        if (!element.isRoot) {
            fw.write("\tpublic static final int InsideTag" + element.getNameWithUpperChar() + " = " + this.id++ + " ;\n");
            fw.write("\tpublic static final int AttributeTag" + element.getNameWithUpperChar() + " = " + this.id++ + " ;\n");
        }
        int i = element.elementsPtr + 1;
        while (--i >= 0) {
            if (this.currentColoredElement.at(element.elements[i]) != null) continue;
            this.generateElementId(element.elements[i], fw);
        }
    }

    private void generateTagId(TagNode node, FileWriter fw) throws IOException {
        fw.write("\tpublic static final int Tag" + node.id + " = " + this.id++ + " ;");
        fw.write("\t// " + String.valueOf(node.characters) + "\n");
        int i = node.elementsPtr + 1;
        while (--i >= 0) {
            this.generateTagId(node.elements[i], fw);
        }
    }

    public void generateParserFile(XmlElementDescriptor root) {
        try {
            FileWriter fw = this.parserFile;
            fw.write(this.option.getCopyrightHeader());
            fw.write("package " + this.option.outputPackage + " ;\n");
            fw.write("public abstract class " + this.option.getClassName("XmlParser") + " implements " + this.option.getClassName("TagsId") + ", " + this.option.getClassName("XmlElementIds") + "," + "com.is2t.tools.xml.XMLDataReader" + " {\n");
            fw.write("\n");
            fw.write("\tpublic " + this.option.getClassName("XmlTag") + " " + "currentXmlTag" + ";\n");
            fw.write("\n");
            fw.write("\tpublic char[] buffer ;\n");
            fw.write("\tpublic int bufferPtr ;\n");
            fw.write("\tprivate int currentStartTag;\n");
            fw.write("\tprivate boolean[] currentAttributeSet;\n");
            fw.write("\n");
            fw.write("\tpublic int errorCode;\t// 0 = no error\n");
            fw.write("\tpublic String errorString;\t// can be null\n");
            fw.write("\tpublic " + this.option.getClassName("XmlTag") + " " + "errorTag" + ";\t// can be null. When errorCode != 0, can points the tag which generate error\n");
            fw.write("\t//error codes\n");
            fw.write("\tpublic static final int NO_ERROR=0;\n");
            fw.write("\tpublic static final int DUPLICATE_ATTRIBUTE=1;\n");
            fw.write("\tpublic static final int MISSING_ATTRIBUTE=2;\n");
            fw.write("\n");
            this.generateParserConstructorMethod(fw, "\t");
            fw.write("\n");
            this.generateParserDestructorMethod(fw, "\t");
            fw.write("\n");
            this.generateParserMainMethod(fw, "\t", root);
            fw.write("\n");
            this.generateParseAttributeValueMethod(fw, "\t");
            fw.write("\n");
            this.generateAddDataMethod(fw, "\t");
            fw.write("\n");
            this.generateInitCurrentAttributeSetMethod(fw, "\t");
            this.currentColoredElement = new ObjectToObjectTable();
            this.generateCreateTagMethod(fw, "\t", root);
            fw.write("\n");
            this.currentColoredElement = new ObjectToObjectTable();
            this.generateCreateAttributeMethods(fw, "\t", root);
            fw.write("\n");
            this.generateFinishMethod(fw, "\t");
            fw.write("\n");
            this.generateCheckMandatoryAttributesMethod(fw, "\t");
            fw.write("\n");
            this.generateParseCommentMethod(fw, "\t");
            fw.write("\n");
            this.generateReadMethod(fw, "\t");
            fw.write("\n");
            this.generateGetPositionMethod(fw, "\t");
            fw.write("\n");
            this.generateErrorDescriptionMethod(fw, "\t");
            this.generateReadEntitiesRefMethod(fw, "\t");
            fw.write("\n");
            fw.write("}");
            fw.flush();
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkNotCurrentChar(FileWriter fw, String tabs, char erroneousChar) throws IOException {
        if (this.option.checkCharacter) {
            fw.write(tabs + "if (" + "currentChar" + " == " + String.valueOf((int)erroneousChar) + ")\n");
            tabs = tabs.concat("\t");
            this.stopParserWithError(fw, tabs);
        }
    }

    private void checkCurrentChar(FileWriter fw, String tabs, char expectedChar) throws IOException {
        if (this.option.checkCharacter) {
            fw.write(tabs + "if (" + "currentChar" + " != '" + expectedChar + "')\n");
            tabs = tabs.concat("\t");
            this.stopParserWithError(fw, tabs);
            if (expectedChar == '<') {
                tabs = tabs.substring(1);
                fw.write(tabs + "else\n");
                tabs = tabs.concat("\t");
                fw.write(tabs + "currentStartTag" + "= " + "getCurrentPosition" + "();\n");
                tabs = tabs.concat("\t");
            }
        }
    }

    private void checkProlog(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "while(true) {\n");
        tabs = tabs.concat("\t");
        this.generateReadLoop(fw, "currentChar", tabs);
        fw.write(tabs + "if (" + "currentChar" + " != '<')\n");
        this.stopParserWithError(fw, tabs + "\t");
        fw.write(tabs + "else {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
        fw.write(tabs + "if (" + "currentChar" + " == '!') {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
        fw.write(tabs + "if (" + "currentChar" + " != '-')\n");
        this.stopParserWithError(fw, tabs + "\t");
        fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
        fw.write(tabs + "if (" + "currentChar" + " != '-')\n");
        this.stopParserWithError(fw, tabs + "\t");
        fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
        fw.write(tabs + "parseComment" + "(" + "currentChar" + ") ;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else\n");
        fw.write(tabs + "\t" + "break;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "currentStartTag" + "= " + "getCurrentPosition" + "();\n");
    }

    private void stopParserWithError(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "break " + "error" + ";\n");
    }

    private void generateParserMainMethod(FileWriter fw, String tabs, XmlElementDescriptor root) throws IOException {
        fw.write(tabs + "public boolean " + "parse" + "() {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "int" + "[] " + "stack" + " = alloca noInit " + "int" + "[" + this.option.stackLength + "] ;\n");
        fw.write(tabs + "int" + " " + "stackPtr" + " = -1 ;\n");
        fw.write(tabs + "char" + " " + "currentChar" + " = " + "read" + "() ;\n");
        fw.write(tabs + "error" + ":{\n");
        tabs = tabs.concat("\t");
        this.checkProlog(fw, tabs);
        fw.write(tabs + "int" + " " + "currentState" + " = " + "Tag" + root.tagElements.id + " ;\n");
        fw.write(tabs + "while (true) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "switch (" + "currentState" + ") {\n");
        this.currentColoredElement = new ObjectToObjectTable();
        this.generateCaseOfElement(fw, tabs, root);
        this.currentColoredElement = new ObjectToObjectTable();
        this.generateCaseInsideOfElement(fw, tabs, root);
        this.currentColoredElement = new ObjectToObjectTable();
        this.generateCaseAttributeOfElement(fw, tabs, root);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}// end " + "error" + "\n");
        fw.write(tabs + "return false; // parse ends with errors\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}// end parse\n");
    }

    private void generateCaseOfElement(FileWriter fw, String tabs, XmlElementDescriptor element) throws IOException {
        this.currentColoredElement.atPut(element, new Object());
        this.generateCaseOfTag(fw, tabs, element.tagElements);
        this.generateCaseOfTagAttribute(fw, tabs, element.tagAttributes);
        int i = element.elementsPtr + 1;
        while (--i >= 0) {
            if (this.currentColoredElement.at(element.elements[i]) != null) continue;
            this.generateCaseOfElement(fw, tabs, element.elements[i]);
        }
    }

    private void generateCaseInsideOfElement(FileWriter fw, String tabs, XmlElementDescriptor element) throws IOException {
        this.currentColoredElement.atPut(element, new Object());
        if (!element.isRoot) {
            fw.write(tabs + "case " + "InsideTag" + element.getNameWithUpperChar() + " : {\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "bufferPtr" + " = -1 ;\n");
            fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
            this.generateReadLoop(fw, "currentChar", tabs);
            fw.write(tabs + "while (" + "currentChar" + " != '<') {\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "if(" + "currentChar" + " == " + "'\\u001a'" + ") break; // EOF : stop filling the buffer\n");
            fw.write(tabs + "buffer" + "[++" + "bufferPtr" + "] = " + "readEntitiesRefMethodName" + "(" + "currentChar" + ") ;\n");
            fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            fw.write(tabs + "currentStartTag" + "= " + "getCurrentPosition" + "();\n");
            fw.write(tabs + "addDataInTag" + "() ;\n");
            int id = element.tagElements.id;
            fw.write(tabs + "currentState" + " = " + "Tag" + id + ";\n");
            fw.write(tabs + "break ;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
        }
        int i = element.elementsPtr + 1;
        while (--i >= 0) {
            if (this.currentColoredElement.at(element.elements[i]) != null) continue;
            this.generateCaseInsideOfElement(fw, tabs, element.elements[i]);
        }
    }

    private void generateReadMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public abstract " + "char" + " " + "read" + "() ;\n");
    }

    private void generateGetPositionMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public abstract int " + " " + "getCurrentPosition" + "() ;\n");
    }

    private String charToString(char c) {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
        }
        return String.valueOf(c);
    }

    private void generateReadLoop(FileWriter fw, String var, String tabs) throws IOException {
        fw.write(tabs + "while (");
        int i = -1;
        while (++i < separators.length) {
            if (i != 0) {
                fw.write(" || ");
            }
            fw.write(var + " == '" + separators[i] + "'");
        }
        fw.write(") {\n");
        fw.write(tabs + "\t" + var + " = " + "read" + "() ;\n");
        fw.write(tabs + "}\n");
    }

    private void generateCaseOfTag(FileWriter fw, String tabs, TagNode node) throws IOException {
        int i;
        fw.write(tabs + "case " + "Tag" + node.id + " : {\t// " + node.begin + "\n");
        tabs = tabs.concat("\t");
        int n = i = node.isBegin ? -1 : 0;
        while (++i < node.charactersPtr + 1) {
            char c = node.characters[i];
            if (node.id != 0 || i != 0) {
                fw.write(tabs + "currentChar" + " = " + "read" + "() ;\t// " + "read " + c + "\n");
            }
            this.checkCurrentChar(fw, tabs, c);
        }
        fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
        if (node.isComment) {
            fw.write(tabs + "parseComment" + "(" + "currentChar" + ") ;\n");
            fw.write(tabs + "currentState" + " = " + "InsideTag" + node.xmlElement.getNameWithUpperChar() + " ;\n");
        }
        fw.write(tabs);
        i = node.elementsPtr + 1;
        while (--i >= 0) {
            TagNode tag = node.elements[i];
            char c = tag.characters[0];
            fw.write("if (currentChar == '" + c + "') {\n");
            fw.write(tabs + "\t" + "currentState" + " = " + "Tag" + tag.id + " ;\n");
            fw.write(tabs + "}\n");
            if (i >= 1) {
                fw.write(tabs + "else ");
                continue;
            }
            if (!this.option.checkCharacter || node.isFinal) continue;
            fw.write(tabs + "else{//invalid character\n");
            this.stopParserWithError(fw, tabs + '\t');
            fw.write(tabs + "}\n");
        }
        if (node.isFinal) {
            if (node.elementsPtr != -1) {
                fw.write(tabs + "else{\n" + tabs + "\t");
            }
            String tagName = node.getStringWithUpperFirstChar();
            fw.write("createTag" + tagName + "() ;\n");
            fw.write(tabs + "\t" + "currentState" + " = " + "AttributeTag" + node.getStringWithUpperFirstChar() + " ;\n");
            if (node.elementsPtr != -1) {
                fw.write(tabs + "}\n");
            }
        } else if (node.isEndTag) {
            this.checkCurrentChar(fw, tabs, '>');
            this.testFinished(fw, tabs);
            fw.write(tabs + "currentState" + " = " + "stack" + "[--" + "stackPtr" + "] ;\n");
            fw.write(tabs + "currentChar" + " = " + "read" + "() ;\t// read '<'\n");
            this.generateReadLoop(fw, "currentChar", tabs);
            this.checkCurrentChar(fw, tabs, '<');
        }
        fw.write(tabs + "break ;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        i = node.elementsPtr + 1;
        while (--i >= 0) {
            this.generateCaseOfTag(fw, tabs, node.elements[i]);
        }
    }

    private void generateCaseOfTagAttribute(FileWriter fw, String tabs, TagNode node) throws IOException {
        fw.write(tabs + "case " + "Tag" + node.id + " : {\t// " + node.begin + "\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "int start= " + "getCurrentPosition" + "();\n");
        int i = 0;
        while (++i < node.charactersPtr + 1) {
            char c = node.characters[i];
            fw.write(tabs + "currentChar" + " = " + "read" + "() ;\t// " + "read " + c + "\n");
            this.checkCurrentChar(fw, tabs, c);
        }
        if (node.charactersPtr != -1) {
            fw.write(tabs + "currentChar" + " = " + "read" + "();\n");
        }
        i = node.elementsPtr + 1;
        while (--i >= 0) {
            TagNode tag = node.elements[i];
            char c = tag.characters[0];
            fw.write(tabs + "if (" + "currentChar" + " == '" + c + "') {\n");
            fw.write(tabs + "\t" + "currentState" + " = " + "Tag" + tag.id + " ;\n");
            fw.write(tabs + "}\n");
            if (i >= 1) {
                fw.write(tabs + "else ");
                continue;
            }
            if (!this.option.checkCharacter) continue;
            fw.write(tabs + "else{ // unexpected character\n");
            tabs = tabs.concat("\t");
            this.stopParserWithError(fw, tabs);
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
        }
        if (node.isFinal) {
            fw.write(tabs + "currentChar" + " = " + "parseAttributeValue" + "(" + "currentChar" + ") ;\n");
            this.checkNotCurrentChar(fw, tabs, '\u0000');
            fw.write(tabs + "if ( !" + "createAttribute" + node.getStringWithUpperFirstChar() + "( start, " + "getCurrentPosition" + "()))\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "break error;\n");
            tabs = tabs.substring(1);
            XmlElementDescriptor element = node.xmlElement;
            fw.write(tabs + "currentState" + " = " + "AttributeTag" + element.getNameWithUpperChar() + " ;\n");
        }
        fw.write(tabs + "break ;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        i = node.elementsPtr + 1;
        while (--i >= 0) {
            this.generateCaseOfTagAttribute(fw, tabs, node.elements[i]);
        }
    }

    private void generateInitCurrentAttributeSetMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "private void " + "initCurrentAttributeSet" + "(int nbAttributes) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "if (" + "currentAttributeSet" + ".length < nbAttributes ) { //must grow \n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "free(" + "currentAttributeSet" + ");\n");
        fw.write(tabs + "currentAttributeSet" + " = new boolean[nbAttributes];\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else { //init to false\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "for (int i = nbAttributes; --i >=0; ) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "currentAttributeSet" + "[i] = false;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write("\n");
    }

    private void generateCreateTagMethod(FileWriter fw, String tabs, XmlElementDescriptor element) throws IOException {
        this.currentColoredElement.atPut(element, new Object());
        if (!element.isRoot) {
            fw.write(tabs + "public void " + "createTag" + element.getNameWithUpperChar() + "() {\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + this.option.getClassName("XmlTag") + " " + "tag" + " = new " + this.option.getClassName("XmlElement" + element.getNameWithUpperChar()) + "(" + "xmlElement" + element.getNameWithUpperChar() + "," + "currentStartTag" + " ) ;\n");
            if (!element.isFirstElement) {
                fw.write(tabs + "currentXmlTag" + "." + "addChild" + "(" + "tag" + ") ;\n");
            }
            fw.write(tabs + "currentXmlTag" + " = " + "tag" + " ;\n");
            fw.write(tabs + "initCurrentAttributeSet" + "( " + element.getAttributesMaxNumber() + ");\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
        }
        int i = element.elementsPtr + 1;
        while (--i >= 0) {
            if (this.currentColoredElement.at(element.elements[i]) != null) continue;
            this.generateCreateTagMethod(fw, tabs, element.elements[i]);
        }
    }

    private void generateAddDataMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public void " + "addDataInTag" + "() {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "int" + " " + "dataLength" + " = " + "bufferPtr" + " + 1 ;\n");
        fw.write(tabs + "if( " + "dataLength" + " > 0 ){\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "int" + " " + "index" + ";\n");
        fw.write(tabs + "char" + "[] " + "data" + ";\n");
        fw.write(tabs + "if( " + "currentXmlTag" + "." + "data" + " != null ){\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "index" + " = " + "currentXmlTag" + "." + "data" + ".length;\n");
        fw.write(tabs + "data" + " = new noInit " + "char" + "[" + "dataLength" + "+" + "index" + "];\n");
        fw.write(tabs + "Array.copy" + "(" + "currentXmlTag" + "." + "data" + ", 0, " + "data" + ", 0, " + "index" + ");\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else{\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "index" + " = 0;\n");
        fw.write(tabs + "data" + " = new noInit " + "char" + "[" + "dataLength" + "];\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "Array.copy" + "(" + "buffer" + ", 0, " + "data" + ", " + "index" + ", " + "dataLength" + ");\n");
        fw.write(tabs + "currentXmlTag" + "." + "data" + " = " + "data" + " ;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void testFinished(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "if (" + "finish" + "()) return true;\n");
    }

    private void testMandatoryAttribute(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "if( !" + "checkMandatoryAttributes" + "()) break error;\n");
    }

    private void generateCaseAttributeOfElement(FileWriter fw, String tabs, XmlElementDescriptor element) throws IOException {
        this.currentColoredElement.atPut(element, new Object());
        if (!element.isRoot) {
            fw.write(tabs + "case " + "AttributeTag" + element.getNameWithUpperChar() + " : {\n");
            tabs = tabs.concat("\t");
            this.generateReadLoop(fw, "currentChar", tabs);
            if (!element.isRoot) {
                fw.write(tabs + "if (" + "currentChar" + " == '/') {\n");
                tabs = tabs.concat("\t");
                fw.write(tabs + "currentChar" + " = " + "read" + "() ;\t// read '>'\n");
                this.checkCurrentChar(fw, tabs, '>');
                this.testMandatoryAttribute(fw, tabs);
                this.testFinished(fw, tabs);
                fw.write(tabs + "currentState" + " = " + "stack" + "[" + "stackPtr" + "] ;\n");
                fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
                this.generateReadLoop(fw, "currentChar", tabs);
                this.checkCurrentChar(fw, tabs, '<');
                tabs = tabs.substring(1);
                fw.write(tabs + "}\n");
                fw.write(tabs + "else ");
            } else {
                fw.write(tabs);
            }
            fw.write("if (currentChar == '>') {\n");
            tabs = tabs.concat("\t");
            this.testMandatoryAttribute(fw, tabs);
            int id = element.tagElements.id;
            fw.write(tabs + "stack" + "[++" + "stackPtr" + "] = " + "Tag" + id + " ;\n");
            fw.write(tabs + "currentState" + " = " + "InsideTag" + element.getNameWithUpperChar() + " ;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            if (element.attributesPtr != -1) {
                fw.write(tabs + "else {\n");
                tabs = tabs.concat("\t");
                int tagId = element.tagAttributes.id;
                fw.write(tabs + "currentState" + " = " + "Tag" + tagId + " ;\n");
                tabs = tabs.substring(1);
                fw.write(tabs + "}\n");
            }
            fw.write(tabs + "break ;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
        }
        int i = element.elementsPtr + 1;
        while (--i >= 0) {
            if (this.currentColoredElement.at(element.elements[i]) != null) continue;
            this.generateCaseAttributeOfElement(fw, tabs, element.elements[i]);
        }
    }

    private void generateParseAttributeValueMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "private " + "char" + " " + "parseAttributeValue" + "(" + "char" + " " + "currentChar" + ") {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "bufferPtr" + " = -1 ;\n");
        fw.write(tabs + "// read until '='\n");
        this.generateReadLoop(fw, "currentChar", tabs);
        fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
        fw.write(tabs + "// read until '\"' or '\\''\n");
        this.generateReadLoop(fw, "currentChar", tabs);
        fw.write(tabs + "char limitChar = " + "currentChar" + ";\n");
        fw.write(tabs + "if( limitChar!='\"' && limitChar!='\\'' )\n");
        fw.write(tabs + "\treturn (char)0;\n");
        fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
        fw.write(tabs + "while (" + "currentChar" + " != limitChar) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "char" + " c = " + "currentChar" + ";\n\n");
        fw.write(tabs + "if(c == " + "'\\u001a'" + ") break; //EOF break\n");
        fw.write(tabs + "if(c == '&'){//entity references in XML, hereafter the five base-defined references in XML are the only ones parsed\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "char" + " secondChar = " + "read" + "();\n");
        fw.write(tabs + "if(secondChar == 'q'){//&quot;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = '\"';\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else if(secondChar == 'a'){\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "char" + " thirdChar = " + "read" + "();\n");
        fw.write(tabs + "if(thirdChar == 'p'){//&apos;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = '\\'';\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else{//&amp;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = '&';\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else if(secondChar == 'l'){//&lt;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = '<';\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else if(secondChar == 'g'){//&gt;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = '>';\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else if(secondChar == '#'){//&#...;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = " + "com.is2t.tools.xml.XMLHelper" + "." + "readUnicode" + "(this);\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else if(c == '\\n'){\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = ' ';\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "buffer" + "[++" + "bufferPtr" + "] = c ;\n");
        fw.write(tabs + "currentChar" + " = " + "read" + "() ;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "return " + "read" + "() ;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void generateReadEntitiesRefMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "private " + "char" + " " + "readEntitiesRefMethodName" + "(" + "char" + " c" + ") {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "if(c == '&'){// hereafter the five base-defined references in XML are the only ones parsed\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "char" + " secondChar = " + "read" + "();\n");
        fw.write(tabs + "if(secondChar == 'q'){//&quot;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = '\"';\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else if(secondChar == 'a'){\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "char" + " thirdChar = " + "read" + "();\n");
        fw.write(tabs + "if(thirdChar == 'p'){//&apos;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = '\\'';\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else{//&amp;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = '&';\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else if(secondChar == 'l'){//&lt;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = '<';\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "else if(secondChar == 'g'){//&gt;\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "c = '>';\n");
        fw.write(tabs + "read" + "();\n");
        fw.write(tabs + "read" + "();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "return c;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void generateCreateAttributeMethods(FileWriter fw, String tabs, XmlElementDescriptor element) throws IOException {
        this.currentColoredElement.atPut(element, new Object());
        this.generateCreateAttributeMethod(fw, tabs, element.tagAttributes);
        int i = element.elementsPtr + 1;
        while (--i >= 0) {
            if (this.currentColoredElement.at(element.elements[i]) != null) continue;
            this.generateCreateAttributeMethods(fw, tabs, element.elements[i]);
        }
    }

    private void generateCreateAttributeMethod(FileWriter fw, String tabs, TagNode node) throws IOException {
        if (node.isFinal) {
            fw.write(tabs + "public boolean " + "createAttribute" + node.getStringWithUpperFirstChar() + "( int " + "startPosition" + ", int " + "stopPosition" + ") {\n");
            tabs = tabs.concat("\t");
            int attributeIndex = -1;
            XmlAttributeDescriptor[] attList = node.xmlElement.attributes;
            int i = node.xmlElement.attributesPtr + 1;
            while (--i >= 0) {
                if (!attList[i].name.equals(node.begin)) continue;
                attributeIndex = i;
            }
            fw.write(tabs + "//check only one time the same attribute on a tag\n");
            fw.write(tabs + "if ( " + "currentAttributeSet" + "[ " + attributeIndex + "]){\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "errorCode" + "= DUPLICATE_ATTRIBUTE;\n");
            fw.write(tabs + "errorTag" + " = currentXmlTag;\n");
            fw.write(tabs + "errorString" + " =  \"" + attList[attributeIndex].name + "\";\n");
            fw.write(tabs + "return false;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
            fw.write(tabs + "else\n");
            tabs = tabs.concat("\t");
            fw.write(tabs + "currentAttributeSet" + "[ " + attributeIndex + "]=true;\n\n");
            tabs = tabs.substring(1);
            String elementName = node.xmlElement.getNameWithUpperChar();
            fw.write(tabs + this.option.getClassName("XmlElement" + elementName) + " " + "tag" + " = (" + this.option.getClassName("XmlElement" + elementName) + ") " + "currentXmlTag" + " ;\n");
            fw.write(tabs + "int" + " " + "dataLength" + " = " + "bufferPtr" + " + 1 ;\n");
            fw.write(tabs + "char" + "[] " + "data" + " = new noInit " + "char" + "[" + "dataLength" + "] ;\n");
            fw.write(tabs + "Array.copy" + "(" + "buffer" + ", 0, " + "data" + ", 0, " + "dataLength" + ") ;\n");
            String att = "tag." + XmlParserGenerator.getAttributeName(node.begin);
            fw.write(tabs + att + " = " + "data" + " ;\n");
            fw.write(tabs + att + "Start = " + "startPosition" + ";\n");
            fw.write(tabs + att + "Stop = " + "stopPosition" + ";\n");
            fw.write(tabs + "return true;\n");
            tabs = tabs.substring(1);
            fw.write(tabs + "}\n");
        }
        int i = node.elementsPtr + 1;
        while (--i >= 0) {
            this.generateCreateAttributeMethod(fw, tabs, node.elements[i]);
        }
    }

    private void generateParserConstructorMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public " + this.option.getClassName("XmlParser") + "() {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "buffer" + " = new noInit " + "char" + "[" + this.option.bufferLength + "];\n");
        fw.write(tabs + "bufferPtr" + " = -1;\n");
        fw.write(tabs + "currentStartTag" + " = -1;\n");
        fw.write(tabs + "currentAttributeSet" + "= new boolean[5];\t//default value to false\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void generateParserDestructorMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public void dispose() {\n");
        tabs = tabs.concat("\t");
        this.delete(fw, tabs, "buffer");
        this.delete(fw, tabs, "errorString");
        this.delete(fw, tabs, "currentAttributeSet");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void delete(FileWriter fw, String tabs, String attname) throws IOException {
        fw.write(tabs + "if(" + attname + "!=null) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "delete(" + attname + ");\n");
        fw.write(tabs + attname + " = null;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void generateFinishMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public boolean " + "finish" + "() {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "currentXmlTag" + "." + "stopPosition" + "= " + "getCurrentPosition" + "();\n");
        fw.write(tabs + "if (" + "currentXmlTag" + "." + "father" + " == null) {\n");
        fw.write(tabs + "\treturn " + "true" + " ;\n");
        fw.write(tabs + "}\n");
        fw.write(tabs + "else {\n");
        fw.write(tabs + "\t" + "currentXmlTag" + " = " + "currentXmlTag" + "." + "father" + " ;\n");
        fw.write(tabs + "\treturn " + "false" + " ;\n");
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void generateCheckMandatoryAttributesMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public boolean " + "checkMandatoryAttributes" + "() {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "boolean[] b = currentXmlTag." + "getOptionalAttributes" + "();\n");
        fw.write(tabs + "for (int i = b.length; --i >=0;) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "if ( ! b[i] && " + "currentAttributeSet" + "[i] == false) {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "errorCode" + "= MISSING_ATTRIBUTE;\n");
        fw.write(tabs + "errorTag" + "= currentXmlTag;\n");
        fw.write(tabs + "errorString" + "= currentXmlTag." + "getAttributeNameAt" + "(i);\n");
        fw.write(tabs + "delete b;\n");
        fw.write(tabs + "return false;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "delete b;\n");
        fw.write(tabs + "return true;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void generateParseCommentMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public void " + "parseComment" + "(char " + "ch1" + ") {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "char" + " " + "ch2" + " = " + "read" + "() ;\n");
        fw.write(tabs + "char" + " " + "ch3" + " = " + "read" + "() ;\n");
        fw.write(tabs + "while (" + "ch1" + " != '-' || " + "ch2" + " != '-' || " + "ch3" + " != '>') {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "if(" + "ch1" + " == " + "'\\u001a'" + ") break;// EOF break\n");
        fw.write(tabs + "ch1" + " = " + "ch2" + " ;\n");
        fw.write(tabs + "ch2" + " = " + "ch3" + " ;\n");
        fw.write(tabs + "ch3" + " = " + "read" + "() ;\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }

    private void generateAppendString(FileWriter fw, String tabs, String aString) throws IOException {
        char[] str = aString.toCharArray();
        int size = str.length - 1;
        fw.write(tabs + "sb.");
        for (int i = 0; i < size; ++i) {
            fw.write("append('" + str[i] + "').");
        }
        fw.write("append('" + str[size] + "');\n");
    }

    private void generateErrorDescriptionMethod(FileWriter fw, String tabs) throws IOException {
        fw.write(tabs + "public String getErrorDescription() {\n");
        tabs = tabs.concat("\t");
        fw.write(tabs + "StringBuilder sb= new StringBuilder();\n");
        fw.write(tabs + "switch (errorCode) {\n");
        fw.write(tabs + "case DUPLICATE_ATTRIBUTE: {\n");
        tabs = tabs.concat("\t");
        this.generateAppendString(fw, tabs, "duplicate attribute [");
        fw.write(tabs + "sb.append(errorString);\n");
        fw.write(tabs + "sb.append(']');\n");
        fw.write(tabs + "return sb.toStringAndFree();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "case MISSING_ATTRIBUTE: {\n");
        tabs = tabs.concat("\t");
        this.generateAppendString(fw, tabs, "missing attribute [");
        fw.write(tabs + "sb.append(errorString);\n");
        fw.write(tabs + "sb.append(']');\n");
        fw.write(tabs + "return sb.toStringAndFree();\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
        fw.write(tabs + "default : return null;\n");
        fw.write(tabs + "}\n");
        tabs = tabs.substring(1);
        fw.write(tabs + "}\n");
    }
}

