/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.xmlParserGenerator.descriptor;

import com.militsa.tools.ObjectToObjectTable;
import com.militsa.xmlParserGenerator.TagNode;
import com.militsa.xmlParserGenerator.descriptor.XmlAttributeDescriptor;

public class XmlElementDescriptor {
    public static ObjectToObjectTable coloredElements;
    public String name;
    public XmlAttributeDescriptor[] attributes;
    public int attributesPtr;
    public XmlElementDescriptor[] elements;
    public int elementsPtr;
    public boolean isRoot;
    public boolean isFirstElement;
    public TagNode tagElements;
    public TagNode tagAttributes;

    public XmlElementDescriptor(String name) {
        this.name = name;
        this.isRoot = false;
        this.isFirstElement = false;
        this.attributes = new XmlAttributeDescriptor[10];
        this.attributesPtr = -1;
        this.elements = new XmlElementDescriptor[10];
        this.elementsPtr = -1;
    }

    public void addXmlAttributeDescriptor(XmlAttributeDescriptor attribute) {
        try {
            this.attributes[++this.attributesPtr] = attribute;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.attributes = new XmlAttributeDescriptor[this.attributesPtr * 2];
            System.arraycopy(this.attributes, 0, this.attributes, 0, this.attributesPtr);
            this.attributes[this.attributesPtr] = attribute;
        }
    }

    public void addXmlElementDescriptor(XmlElementDescriptor element) {
        try {
            this.elements[++this.elementsPtr] = element;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.elements = new XmlElementDescriptor[this.elementsPtr * 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.elementsPtr);
            this.elements[this.elementsPtr] = element;
        }
    }

    public XmlElementDescriptor getElementNamed(String name) {
        int i = this.elementsPtr + 1;
        while (--i >= 0) {
            if (!this.elements[i].name.equals(name)) continue;
            return this.elements[i];
        }
        return null;
    }

    public TagNode getTagNamed(String name) {
        TagNode node = this.tagElements;
        return this.getTagNamed(node, name, 0);
    }

    private TagNode getTagNamed(TagNode node, String name, int charPtr) {
        if (node.begin.equals(name)) {
            return node;
        }
        TagNode tag = node.getTagNodeWithCharacter(name.charAt(charPtr));
        return this.getTagNamed(tag, name, charPtr += tag.charactersPtr + 1);
    }

    public String getNameWithUpperChar() {
        char firstChar = this.name.charAt(0);
        String endStr = this.name.substring(1);
        return String.valueOf(firstChar).toUpperCase().concat(endStr);
    }

    public int getAttributesMaxNumber() {
        return this.attributesPtr + 1;
    }

    public String toString() {
        return this.name;
    }
}

