/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.xmlParserGenerator;

import com.militsa.tools.ObjectToObjectTable;
import com.militsa.xmlParserGenerator.TagNode;
import com.militsa.xmlParserGenerator.XmlParserGeneratorOption;
import com.militsa.xmlParserGenerator.descriptor.XmlElementDescriptor;
import com.militsa.xmlParserGenerator.filewriter.IceTeaParserFileWriter;
import com.militsa.xmlParserGenerator.filewriter.IceTeaXmlElementWriter;
import java.util.Arrays;
import java.util.List;

public class XmlParserGenerator {
    public static int id;
    public XmlElementDescriptor descriptor;
    public IceTeaParserFileWriter parserFileWriter;
    public IceTeaXmlElementWriter xmlElementFileWriter;
    public XmlParserGeneratorOption option;
    private static final List<String> Keywords;

    public XmlParserGenerator(XmlElementDescriptor descriptor, XmlParserGeneratorOption option) {
        id = 0;
        this.descriptor = descriptor;
        this.option = option;
        this.parserFileWriter = new IceTeaParserFileWriter(option);
        this.xmlElementFileWriter = new IceTeaXmlElementWriter(option);
    }

    public void generate() {
        XmlElementDescriptor root = new XmlElementDescriptor("");
        root.isRoot = true;
        root.addXmlElementDescriptor(this.descriptor);
        this.descriptor.isFirstElement = true;
        XmlElementDescriptor.coloredElements = new ObjectToObjectTable();
        this.generateTagNode(root);
        this.parserFileWriter.generateTagIdFile(root);
        this.parserFileWriter.generateParserFile(root);
        this.xmlElementFileWriter.generateXmlTagFile();
        XmlElementDescriptor.coloredElements = new ObjectToObjectTable();
        this.xmlElementFileWriter.generateXmlElementFile(this.descriptor);
        XmlElementDescriptor.coloredElements = new ObjectToObjectTable();
        this.xmlElementFileWriter.generateXmlElementIdsFile(this.descriptor);
        System.out.println("Parser finished");
    }

    private void generateTagNode(XmlElementDescriptor element) {
        XmlElementDescriptor.coloredElements.atPut(element, new Object());
        TagNode tagElem = new TagNode(element);
        tagElem.isBegin = true;
        tagElem.isAttributeTag = false;
        element.tagElements = tagElem;
        int i = element.elementsPtr + 1;
        while (--i >= 0) {
            tagElem.addTag(element.elements[i].name);
        }
        if (!element.isRoot) {
            tagElem.addTag(String.valueOf('/').concat(element.name));
            tagElem.addTag("!--");
        }
        tagElem.parse();
        tagElem.reduce();
        tagElem.setId();
        TagNode tagAttr = new TagNode(element);
        tagAttr.isAttributeTag = true;
        element.tagAttributes = tagAttr;
        int i2 = element.attributesPtr + 1;
        while (--i2 >= 0) {
            tagAttr.addTag(element.attributes[i2].name);
        }
        tagAttr.parse();
        tagAttr.reduce();
        tagAttr.setId();
        i2 = element.elementsPtr + 1;
        while (--i2 >= 0) {
            XmlElementDescriptor childElement = element.elements[i2];
            if (XmlElementDescriptor.coloredElements.at(childElement) != null) continue;
            this.generateTagNode(childElement);
        }
    }

    public static String getAttributeName(String name) {
        if (XmlParserGenerator.isKeyword(name)) {
            return '_' + name;
        }
        return name;
    }

    private static boolean isKeyword(String name) {
        return Keywords.contains(name);
    }

    static {
        Keywords = Arrays.asList("class", "interface", "private", "protected", "public");
    }
}

