/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.xmlParserGenerator;

import com.militsa.xmlParserGenerator.XmlParserGenerator;
import com.militsa.xmlParserGenerator.descriptor.XmlElementDescriptor;

public class TagNode {
    public String[] tagsToParse;
    public int tagsToParsePtr;
    public TagNode[] elements;
    public int elementsPtr;
    public char[] characters;
    public int charactersPtr;
    public String begin;
    public boolean isAttributeTag;
    public boolean isFinal;
    public boolean isBegin;
    public boolean isEndTag;
    public boolean isComment;
    public int id;
    public XmlElementDescriptor xmlElement;

    public TagNode(XmlElementDescriptor xmlElement) {
        this.xmlElement = xmlElement;
        this.characters = new char[10];
        this.charactersPtr = -1;
        this.tagsToParse = new String[10];
        this.tagsToParsePtr = -1;
        this.elements = new TagNode[10];
        this.elementsPtr = -1;
        this.isFinal = false;
        this.isEndTag = false;
        this.isBegin = false;
        this.begin = "";
    }

    public void addCharacter(char c) {
        try {
            this.characters[++this.charactersPtr] = c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.characters = new char[this.charactersPtr * 2];
            System.arraycopy(this.characters, 0, this.characters, 0, this.charactersPtr);
            this.characters[this.charactersPtr] = c;
        }
    }

    public void addTag(String tag) {
        try {
            this.tagsToParse[++this.tagsToParsePtr] = tag;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.tagsToParse = new String[this.tagsToParsePtr * 2];
            System.arraycopy(this.tagsToParse, 0, this.tagsToParse, 0, this.tagsToParsePtr);
            this.tagsToParse[this.tagsToParsePtr] = tag;
        }
    }

    public void addTagNode(TagNode node) {
        try {
            this.elements[++this.elementsPtr] = node;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.elements = new TagNode[this.elementsPtr * 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.elementsPtr);
            this.elements[this.elementsPtr] = node;
        }
    }

    public void parse() {
        int i = this.tagsToParsePtr + 1;
        while (--i >= 0) {
            String tag = this.tagsToParse[i];
            if (tag.equals("")) {
                if (this.begin.charAt(0) == '/') {
                    this.isFinal = false;
                    this.isEndTag = true;
                    this.isComment = false;
                    continue;
                }
                if (this.begin.charAt(0) == '!') {
                    this.isFinal = false;
                    this.isEndTag = false;
                    this.isComment = true;
                    continue;
                }
                this.isFinal = true;
                this.isEndTag = false;
                this.isComment = false;
                continue;
            }
            char c = tag.charAt(0);
            TagNode node = this.getTagNodeWithCharacter(c);
            if (node == null) {
                node = new TagNode(this.xmlElement);
                node.isAttributeTag = this.isAttributeTag;
                node.addCharacter(c);
                node.begin = this.begin.concat(String.valueOf(c));
                this.addTagNode(node);
            }
            String endTag = tag.substring(1);
            node.addTag(endTag);
        }
        i = this.elementsPtr + 1;
        while (--i >= 0) {
            TagNode node = this.elements[i];
            node.parse();
        }
    }

    public TagNode getTagNodeWithCharacter(char c) {
        int i = this.elementsPtr + 1;
        while (--i >= 0) {
            TagNode node = this.elements[i];
            if (node.characters[0] != c) continue;
            return node;
        }
        return null;
    }

    public void reduce() {
        if (!this.isFinal && this.elementsPtr == 0) {
            TagNode node = this.elements[0];
            this.addCharacter(node.characters[0]);
            this.elements = node.elements;
            this.elementsPtr = node.elementsPtr;
            this.isFinal = node.isFinal;
            this.isEndTag = node.isEndTag;
            this.begin = node.begin;
            this.isComment = node.isComment;
            this.reduce();
        } else {
            int i = this.elementsPtr + 1;
            while (--i >= 0) {
                this.elements[i].reduce();
            }
        }
        this.tagsToParse = null;
        this.tagsToParsePtr = -1;
    }

    public void setId() {
        this.id = XmlParserGenerator.id++;
        int i = this.elementsPtr + 1;
        while (--i >= 0) {
            this.elements[i].setId();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Tag\n");
        sb = sb.append("characters : ");
        int i = -1;
        while (++i < this.charactersPtr + 1) {
            sb = sb.append(this.characters[i]);
        }
        sb = sb.append("\n\n");
        sb = sb.append("Strings :\n");
        i = -1;
        while (++i < this.tagsToParsePtr + 1) {
            sb = sb.append("\t" + this.tagsToParse[i] + "\n");
        }
        sb = sb.append("\nid : " + this.id);
        if (this.isFinal) {
            sb = sb.append("\nfinal node\n");
        }
        return sb.toString();
    }

    public String getStringWithUpperFirstChar() {
        if (this.isAttributeTag) {
            String elementName = this.xmlElement.name;
            char firstElementChar = elementName.charAt(0);
            elementName = elementName.substring(1);
            char firstAttributeChar = this.begin.charAt(0);
            String attributeStr = this.begin.substring(1);
            return String.valueOf(firstElementChar).toUpperCase().concat(elementName).concat(String.valueOf(firstAttributeChar).toUpperCase()).concat(attributeStr);
        }
        char beginChar = this.begin.charAt(0);
        String endString = this.begin.substring(1);
        return String.valueOf(beginChar).toUpperCase().concat(endString);
    }
}

