/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.trace;

import com.militsa.tools.IntToObjectTable;
import com.militsa.trace.LineDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.StringTokenizer;

public class StackTraceDecrypter
extends OutputStream
implements Runnable {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_GETTYPE = 1;
    public static final int STATE_GETSEPARATOR = 2;
    public static final int STATE_GETADDRESS = 3;
    public static final int STATE_LINENUMBER = 4;
    public static final int STATE_THREADID = 5;
    public static final char DELIMITER = '@';
    public static final char SEPARATOR = ':';
    public static final char TYPE_METHOD = 'M';
    public static final char TYPE_CLASS = 'C';
    public static final char TYPE_THREADID = 'I';
    public IntToObjectTable addressToName;
    public int state = 0;
    public char type;
    public StringBuffer buffer;
    public InputStreamReader in;
    public PrintStream out;
    public LineDescriptor lineDescryptor;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Invalid arguments. Usage : StackTraceDecrypter <file>");
            return;
        }
        StackTraceDecrypter decrypter = null;
        try {
            decrypter = new StackTraceDecrypter(args[0], System.in);
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot find file " + args[0]);
            return;
        }
        catch (Throwable e) {
            System.err.println("Error while loading file " + args[0]);
            return;
        }
        try {
            System.out.println("\nCopy/Paste stack trace in the console.\n");
            decrypter.run();
        }
        catch (Throwable e) {
            System.err.println("Internal limits error.");
        }
    }

    public StackTraceDecrypter(String filename, InputStream is) throws IOException {
        this(filename, is, System.out);
    }

    public StackTraceDecrypter(String filename, PrintStream out) throws IOException {
        this(filename, System.in, out);
    }

    public StackTraceDecrypter(String filename, InputStream in, PrintStream out) throws IOException {
        this.in = new InputStreamReader(in, this.getDefaultEncoding());
        this.out = out;
        this.addressToName = new IntToObjectTable();
        this.fillDatabase(filename);
    }

    public StackTraceDecrypter(IntToObjectTable addressToName, InputStream in, PrintStream out) throws IOException {
        this.in = new InputStreamReader(in, this.getDefaultEncoding());
        this.out = out;
        this.addressToName = addressToName;
    }

    public void fillDatabase(String filename) throws IOException {
        String line;
        IntToObjectTable addressToName = this.addressToName;
        int nbLoaded = 0;
        int lineNumber = 0;
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        while ((line = raf.readLine()) != null) {
            ++lineNumber;
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            try {
                tokenizer.nextElement();
                String address = (String)tokenizer.nextElement();
                String name = (String)tokenizer.nextElement();
                if (address != null && name != null) {
                    int iaddress = Integer.parseInt(address);
                    addressToName.atPut(iaddress, name);
                    ++nbLoaded;
                    continue;
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            System.out.println("Invalid data at line " + lineNumber + " : " + line);
        }
        raf.close();
        System.out.println(nbLoaded + " elements loaded from " + filename + ".");
    }

    @Override
    public void run() {
        int readChar = 0;
        this.state = 0;
        try {
            while ((readChar = this.in.read()) != -1) {
                this.write(readChar);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(int readChar) throws IOException {
        block33: {
            char c = (char)readChar;
            if (this.state == 0) {
                if (this.isDelimiter(c)) {
                    this.state = 1;
                } else if (c != '\u0000') {
                    this.out.print(c);
                }
            } else if (this.state == 1) {
                if (this.isType(c)) {
                    this.type = c;
                    this.state = 2;
                } else {
                    this.out.print('@');
                    this.out.print(c);
                    this.state = 0;
                }
            } else if (this.state == 2) {
                if (this.isSeparator(c)) {
                    this.buffer = new StringBuffer();
                    this.state = this.type == 'I' ? 5 : 3;
                } else {
                    this.out.print('@');
                    this.out.print(this.type);
                    this.out.print(c);
                    this.state = 0;
                }
            } else if (this.state == 3) {
                try {
                    Integer address = this.readNumber(c);
                    if (address == null) break block33;
                    String name = (String)this.addressToName.at(address);
                    if (name != null) {
                        this.out.print(name);
                    } else {
                        this.out.print(this.buffer.toString());
                    }
                    if (this.isDelimiter(c)) {
                        this.state = 0;
                        break block33;
                    }
                    this.buffer = new StringBuffer();
                    this.state = 4;
                }
                catch (NumberFormatException e) {
                    this.out.print('@');
                    this.out.print(this.type);
                    this.out.print(':');
                    this.out.print(this.buffer.toString());
                    this.out.print(c);
                    this.state = 0;
                }
            } else if (this.state == 5) {
                try {
                    Integer id = this.readNumber(c);
                    if (id != null) {
                        String name;
                        this.out.print(id);
                        if (this.lineDescryptor != null && (name = this.lineDescryptor.getThreadNameForId(id)) != null) {
                            this.out.print('(');
                            this.out.print(name);
                            this.out.print(')');
                        }
                        this.state = 0;
                    }
                }
                catch (NumberFormatException e) {
                    this.out.print('@');
                    this.out.print(this.type);
                    this.out.print(':');
                    this.out.print(this.buffer.toString());
                    this.out.print(c);
                    this.state = 0;
                }
            } else if (this.state == 4) {
                try {
                    Integer byteCodeAddress = this.readNumber(c);
                    if (byteCodeAddress != null) {
                        String lineDesc = null;
                        if (this.lineDescryptor != null) {
                            lineDesc = this.lineDescryptor.getLineAt(byteCodeAddress);
                        }
                        if (lineDesc == null) {
                            this.out.print('(');
                            this.out.print(this.buffer.toString());
                            this.out.print(')');
                        } else {
                            this.out.print(lineDesc);
                        }
                        this.state = 0;
                    }
                }
                catch (NumberFormatException e) {
                    this.out.print(':');
                    this.out.print(this.buffer.toString());
                    this.out.print(c);
                    this.state = 0;
                }
            }
        }
        this.flush();
    }

    public Integer readNumber(char readChar) throws IOException, NumberFormatException {
        if (readChar == '-' || readChar == 'x' || readChar == 'X' || Character.digit(readChar, 16) != -1) {
            this.buffer.append(readChar);
            return null;
        }
        if (this.isDelimiter(readChar) || this.isSeparator(readChar)) {
            String strAddress = this.buffer.toString();
            int radix = 10;
            if (strAddress.startsWith("0x")) {
                strAddress = strAddress.substring(2, strAddress.length());
                radix = 16;
            }
            int address = (int)Long.parseLong(strAddress, radix);
            return new Integer(address);
        }
        throw new NumberFormatException();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public boolean isDelimiter(char c) {
        return c == '@';
    }

    public boolean isType(char c) {
        return c == 'C' || c == 'M' || c == 'I';
    }

    public boolean isSeparator(char c) {
        return c == ':';
    }

    public Charset getDefaultEncoding() {
        return Charset.forName("ISO-8859-1");
    }
}

